function job_view_cortex_plot( key )
% job_view_cortex_plot( key )
%
% ]f\ėpC^[tFCX
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

H = get( gcf, 'UserData' );

brain = get( H.braindata, 'UserData' );
act = get( H.actdata, 'UserData' );
area = get( H.areadata, 'UserData' );
selection = get( H.selectdata, 'UserData' );
param = get( H.paramdata, 'UserData' );

% f̑I
switch param.model_type
 case 'original'
  V = brain.V;
 case 'inflate'
  V = brain.Vinflate;
end

% E]/]/ ̑I
switch param.LRflg
 case 'L'
  F = brain.F.F3L;
 case 'R'
  F = brain.F.F3R;
 case 'LR'
  F = brain.F.F3;
end

% }XN̐ ( }XNɊ܂܂钸_()݂̂\ )
if isempty(area.masking)
  mask = [1:length(brain.V)];  % }XNΑS̕\
else
  mask = unique( [ area.source(area.masking).Vi ] );
end

%===  ]f̕\  ================================================
switch key

 case 'brain'
  cla;
  job_view_cortex_plot_brain_model( V, F, brain.S, mask, param );
  job_view_cortex_plot_brain_act_area( V, F, brain.Va, act, area,...
				       mask, param, key );
  job_view_cortex_plot_brain_selected( V, F, selection.Vi, mask, param );
  selected = get( H.activation_plotted_list, 'Value' );
  job_view_cortex_plot_brain_act_highlight( act, param,...
					    act.plotted( selected ) );
  selected = get( H.area_plotted_list, 'Value' );
  job_view_cortex_plot_brain_area_highlight( V, F, area, mask, param,...
					     area.plotted( selected ) );
  alpha(1.0);
  
 case { 'act', 'area' }
  job_view_cortex_plot_brain_act_area( V, F, brain.Va, act, area,...
				       mask, param, key );
  job_view_cortex_plot_brain_selected( V, F, selection.Vi, mask, param );
  selected = get( H.activation_plotted_list, 'Value' );
  job_view_cortex_plot_brain_act_highlight( act, param,...
					    act.plotted( selected ) );
  selected = get( H.area_plotted_list, 'Value' );
  job_view_cortex_plot_brain_area_highlight( V, F, area, mask, param,...
					     area.plotted( selected ) );
  alpha(1.0);
  
 case 'selection'
  job_view_cortex_plot_brain_selected( V, F, selection.Vi, mask, param );
  selected = get( H.activation_plotted_list, 'Value' );
  job_view_cortex_plot_brain_act_highlight( act, param,...
					    act.plotted( selected ) );
  selected = get( H.area_plotted_list, 'Value' );
  job_view_cortex_plot_brain_area_highlight( V, F, area, mask, param,...
					     area.plotted( selected ) );
  
 case 'highlight act'
  selected = get( H.activation_plotted_list, 'Value' );
  job_view_cortex_plot_brain_act_highlight( act,...
					    param, act.plotted( selected ) );

 case 'highlight area'
  selected = get( H.area_plotted_list, 'Value' );
  job_view_cortex_plot_brain_area_highlight( V, F, area, mask, param,...
					     area.plotted( selected ) );

end

material dull;
lighting phong;

% }EX̋@\ĕ]
job_view_cortex_callback( 'mouse func' );



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% ]f̕`
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function job_view_cortex_plot_brain_model( V, F, S, mask, param )
%
% V : _f[^
% F : ʃf[^
% S : _ał邩ǂ̘_z
% mask : \ׂ_CfbNX
% param : p^FXBŎĝ...
%     param.brain_color : f̕`F
%     param.sulcus_visibility: aɐF邩ǂ( visible or invisible )
%     param.sulcus_color     : a̕`F( true color )
%     param.lighting         : CeBO邩ǂ( on or off )
%

% ʂI
FF = vb_patch_select2(mask,F,length(V));

switch param.model_type
 case 'original'
  Vshrink = vb_shrink_cortex_for_plot(V, FF);
  patch( 'Faces', FF, 'Vertices', Vshrink, 'FaceColor', param.brain_color,...
	 'EdgeColor', 'none', 'Tag', 'brain', 'Clipping', 'off' );
 case 'inflate'
  switch param.sulcus_visibility
   case 'visible'
    colors = ( ones(length(V),1) - S' ) * param.brain_color...
	      + S' * param.sulcus_color; 
    Vshrink = vb_shrink_cortex_for_plot(V, FF, true);
    patch( 'Faces', FF, 'Vertices', Vshrink, 'FaceColor', 'interp',...
	   'EdgeColor', 'none', 'FaceVertexCData', colors,...
	   'Tag', 'brain', 'Clipping', 'off' );
   case 'invisible'
    patch( 'Faces', FF, 'Vertices', V, 'FaceColor', param.brain_color,...
	   'EdgeColor', 'none', 'Tag', 'brain', 'Clipping', 'off' );
  end
end
  
switch param.lighting
 case 'on'
  h  = camlight(0, 0);
  set(h,  'UserData', 'light1');
  h2 = camlight(0, 180);
  set(h2, 'UserData', 'light2');
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% ]/]̈̕`
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function job_view_cortex_plot_brain_act_area( V, F, Va, act, area, mask, param, key )
%
% param.act_area_priority ( ]Ɣ]̈̂ǂɕ\邩)
% ɂU蕪
%

switch param.act_area_priority
 case 'activation'
  switch key
   case 'act'
    job_view_cortex_plot_brain_activation( V, F, Va, act, mask, param );
   case { 'brain', 'area' }
    job_view_cortex_plot_brain_area( V, F, area, mask, param );
    job_view_cortex_plot_brain_activation( V, F, Va, act, mask, param );
  end
 case 'area'
  switch key
   case { 'brain', 'act' }
    job_view_cortex_plot_brain_area( V, F, area, mask, param );
    job_view_cortex_plot_brain_activation( V, F, Va, act, mask, param );
   case 'area'
    job_view_cortex_plot_brain_area( V, F, area, mask, param );
  end
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% ]̕`
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function job_view_cortex_plot_brain_activation( V, F, Va, act, mask, param )
%
% V    : _f[^ ( Nv ~ 3 )
% F    : ʃf[^ ( Nf ~ 3 )
% Va   : e_̊ʐ ( Nv ~ 1 )
% act  : f[^\
% mask : \ׂ_̃CfbNX ( Nm ~ 1 )
% param.act_normalize  : x𐳋K邩ǂ
% 	'no'       --- KȂ, ftHg
% 	'meshsize' --- ]f̃bVTCYŐK
% param.act_relative_mode  : x̍őΒľvZ@
% 	'all'  --- .act.matt@ĈׂẴf[^̍őΒl
% 	'each' --- \̃f[^̍őΒl, ftHg
% param.act_min_mode  : `悷銈x̍ŏΒl̐ݒ@
% 	'absolute' --- lŎw
% 	'relative' --- őΒlɑ΂銄Ŏw, ftHg
% param.act_min  : `悷銈x̍ŏΒl
% 	param.act_min_mode = 'absolute' ̏ꍇ͑l
% 	param.act_min_mode = 'relative' ̏ꍇ͍őΒlɑ΂銄
% 	( ftHg0.1 )
% param.act_sign_mode         :
% param.act_colormap_max_mode :
% param.act_colormap_max      : J[̐ݒ
% 	act_sing_mode = 'signed'   ȂAJ[͈̔͂ [ -cmax, cmax ]
% 	act_sing_mode = 'unsigned' ȂAJ[͈̔͂ [ 0, cmax ]
% 	Acmax́Aact_colormap_max_mode A
% 		'absolute' ȂAcmax = act_colormap_max
% 		'relative' ȂAcmax = act_colormap_max ~ őΒl
% 	ftHǵA
% 	act_sign_mode = 'unsigned'
% 	act_colormap_max_mode = 'relative'
% 	act_colormap_max = 1
% param.act_colormap_type  : J[}bṽ^Cv
% 	'jet' --- jet ^Cv, ftHg
% 	'hot' --- hot ^Cv
% param.paint  : x, ̈, Ï̕`@
% 	'patch' --- patch()ŕ`
% 	'dot'   --- plot(_)ŕ`
% param.markersize  : _`掞̃}[J[̑傫
% 	XJl ( ftHg 1 )
%

delete( findobj( gca, 'Tag', 'act' ) );

if isempty( act.plotted ); return; end;

% őΒľvZ
switch param.act_relative_mode
 case 'each'
  Jabsmax = max( abs( [ act.source(act.plotted).J ] ) );
 case 'all'
  Jabsmax = max( abs( [ act.source(act.candidate).J ] ) );
end

% exf[^ɂĕ`
for id = act.plotted

  J = act.source(id).J;

  %%%%% ̐K %%%%%
  switch param.act_normalize
   case 'meshsize'
    J = J ./ Va;
  end

  %%%%% \ׂ_̑I  %%%%%
  % }XLO : mask Ɋ܂܂钸_ F Ɋ܂܂钸_̋ʕ
  ind = intersect( mask, unique(F(:)) );
  % ŏ`抈xɂI
  switch param.act_min_mode
   case 'absolute'
    ind = intersect( ind, find( abs(J) >= param.act_min ) );
   case 'relative'
    ind = intersect( ind, find( abs(J) >= Jabsmax * param.act_min ) );
  end

  %%%%% J[}bvݒ %%%%%
  switch param.act_colormap_max_mode
   case 'absolute'
    cmax = param.act_colormap_max;
   case 'relative'
    cmax = Jabsmax * param.act_colormap_max;
  end

  switch param.act_colormap_type
   case 'hot'
    colormap(hot);
   case 'jet'
    colormap(jet);
  end

  %%%%% Βl\/t\̐؊ *****
  switch param.act_sign_mode
   case 'signed'
    caxis( [ -cmax cmax ] );
   case 'unsigned'
    J = abs(J);
    caxis( [ 0 cmax ] );
  end

  %%%%% ` %%%%%
  switch param.paint
   case 'dot'
    tmp = scatter3( V(ind,1), V(ind,2), V(ind,3), 1, J(ind), '.', 'filled' );
    set( tmp, 'MarkerSize', param.markersize, 'Tag', 'act', 'UserData', id,...
	      'HitTest', 'off', 'Clipping', 'off' );
   case 'patch'
    FF = vb_patch_select2(ind,F,length(V));  
    patch( 'Faces', FF, 'Vertices', V, 'FaceColor', 'interp',...
	   'FaceVertexCData', J', 'EdgeColor', 'none', 'FaceAlpha', 0.99,...
	   'Tag', 'act', 'UserData', id, 'HitTest', 'off', 'Clipping', 'off' );
    alpha(findobj( gca, 'Tag', 'brain' ), 0.99); % to fix display bug for MATLAB r2014b-2015b
  end
  
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% ]̈̕`
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function job_view_cortex_plot_brain_area( V, F, area, mask, param )
%
% V    : _f[^ ( Nv ~ 3 )
% F    : ʃf[^ ( Nf ~ 3 )
% area : f[^\
% mask : \ׂ_̃CfbNX ( Nm ~ 1 )
% param.area_alpha  : ̈\̓x
% 	0.01 ` 0.99 ̃XJl ( ftHg 0.4 )
% param.paint  : x, ̈, Ï̕`@
% 	'patch' --- patch()ŕ`
% 	'dot'   --- plot(_)ŕ`
% param.markersize  : _`掞̃}[J[̑傫
% 	XJl ( ftHg 1 )
%

delete( findobj( gca, 'Tag', 'area' ) );

if isempty( area.plotted ); return; end;

area_colors = [ 1 0 0; 0 1 0; 0 0 1; 1 1 0; 1 0 1; 0 1 1;
		1 1 0.5; 0.5 0 0; 0 0.5 1; 0.5 1 0; 1 0.5 1; 0 0 0.5;
		1 0.5 0; 0 1 0.5; 0.5 0 1; 0 0.5 0; 0.5 1 1; 1 0 0.5;
		1 0.5 0.5; 0 0.5 0.5; 0.5 1 0.5;
		0.5 0 0.5; 0.5 0.5 1; 0.5 0.5 0 ];

for id = area.plotted
  
  ind = intersect( area.source(id).Vi, mask );

  % F Ɋ܂܂Ȃ_̃JbgIt
  ind = intersect( ind, unique(F) );

  if isfield(area.source(id), 'color')
      color = area.source(id).color;
  else
      color = area_colors(1+mod(id-1,length(area_colors)),:);
  end

  % `
  switch param.paint
   case 'dot'
    plot3( V(ind,1), V(ind,2), V(ind,3), '.',...
	   'MarkerFaceColor', color, 'MarkerEdgeColor', color,...
	   'MarkerSize', param.markersize, 'Tag', 'area', 'UserData', id,...
	   'HitTest', 'off', 'Clipping', 'off' );
   case 'patch'
    FF = vb_patch_select2( ind, F, length(V) );
    patch( 'Faces', FF, 'Vertices', V,...
	   'FaceColor', color, 'EdgeColor', 'none', 'FaceLighting', 'none',...
	   'FaceAlpha', param.area_alpha, 'Tag', 'area', 'UserData', id,...
	   'HitTest', 'off', 'Clipping', 'off' );
    alpha(findobj( gca, 'Tag', 'brain' ), 0.99); % to fix display bug for MATLAB r2014b-2015b
  end

  % \ ?????

end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% nCCg̕`
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function job_view_cortex_plot_brain_act_highlight( act, param, selected )
%
% param.act_show_highlight  : x̃nCCg(Plot List̑I)
% 	'on'  --- nCCg, ftHg
% 	'off' --- nCCgȂ
% 	nCCgꂽ̈ȊOɕ\
% param.act_non_highlight_alpha  : nCCgꂽ̈ȊO̊x̓x
% 	0.01 ` 0.99 ̃XJl ( ftHg 0.5 )
%

if isempty( selected ); return; end;
if strcmp( param.act_show_highlight, 'off' ); return; end;

for id = act.plotted
  if ismember( id, selected )
    set( findobj( gca, 'Tag', 'act', 'UserData', id ), 'FaceAlpha', 0.99 );
  else
    set( findobj( gca, 'Tag', 'act', 'UserData', id ),...
	 'FaceAlpha', param.act_non_highlight_alpha );
  end
end


function job_view_cortex_plot_brain_area_highlight( V, F, area, mask,...
						    param, selected )
%
% param.area_show_highlight  : ̈̃nCCg(Plot List̑I)
% 	'on'  --- nCCg, ftHg
% 	'off' --- nCCgȂ
%

delete( findobj( 'Tag', 'area_highlight' ) );

if isempty( area.plotted ) | isempty( selected ); return; end;
if strcmp( param.area_show_highlight, 'off' ); return; end;

Vx = V(:,1); Vy = V(:,2); Vz = V(:,3);

for id = selected
  % GbW̒o
  Vi = intersect( area.source(id).Vi, mask );
  FF = vb_patch_select2( Vi, F, length(V) );
  FL = [ FF(:,1), FF(:,2); FF(:,2), FF(:,3); FF(:,3), FF(:,1) ];
  FL_inv = [ FL(:,2), FL(:,1) ];
  FL = setdiff( FL, FL_inv, 'rows' );
  [ FL_unq, I, J ] = unique( FL, 'rows' );
  edge = setdiff( FL_unq, FL( setdiff( [1:size(FL,1)], I ), : ), 'rows' );
  %GbW̕`
%
%   next = sparse( edge(:,1), edge(:,2), ones(length(edge),1), length(V), length(V), length(edge) );
%   [X,Y] = gplot( next, V, '-' );
%   line( X, Y, 'Color', [0.3,0.3,0.3], 'Tag', 'area_highlight', 'UserData', id );
%
%   Se = mat2cell( edge, ones(1,length(edge)), [2] );
%   for i = 1 : length(Se)
%     for j = i + 1 : length(Se)
%       e1 = Se{i}; e2 = Se{j};
%       if e1(1) == e2(1)
% 	Se{j} = [ e1(length(e1):2), e2 ];
% 	Se{i} = [];
% 	break;
%       elseif e1(1) == e2(length(e2))
% 	Se{j} = [ e2, e1(2:length(e1)) ];
% 	Se{i} = [];
% 	break;
%       elseif e1(length(e1)) == e2(1)
% 	Se{j} = [ e1(1:length(e1)-1), e2 ];
% 	Se{i} = [];
% 	break;
%       elseif e1(length(e1)) == e2(length(e2))
% 	Se{j} = [ e1(1:length(e1)-1), e2 ];
% 	Se{i} = [];
% 	break;
%       end
%     end
%   end
%   for i = 1 : length(Se)
%     if ~isempty(Se{i})
%       e = Se{i};
%       line( Vx(e), Vy(e), Vz(e), 'Color', [0.3,0.3,0.3],...
% 	    'Tag', 'area_highlight', 'UserData', id );
%     end
%   end
%
  line( Vx(edge'), Vy(edge'), Vz(edge'), 'Color', [0.3,0.3,0.3],...
	'Tag', 'area_highlight', 'UserData', id );
end





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Ï̕`
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function job_view_cortex_plot_brain_selected( V, F, Vi, mask, param )
%
% param.selection_color  : ̈I̐F
% 	TrueColor ( ftHg [ 1 1 1 ] )
% param.paint  : x, ̈, Ï̕`@
% 	'patch' --- patch()ŕ`
% 	'dot'   --- plot(_)ŕ`
% param.markersize  : _`掞̃}[J[̑傫
% 	XJl ( ftHg 1 )
%

delete( findobj( gca, 'Tag', 'selected' ) );

if isempty( Vi )
  return;
end

ind = intersect( Vi, mask );

% F Ɋ܂܂Ȃ_̃JbgIt
Vi = intersect( ind, unique(F) );

color = param.selection_color;

% `
if param.paint == 1
  plot3( V(Vi,1), V(Vi,2), V(Vi,3), '.',...
	 'MarkerFaceColor', color, 'MarkerEdgeColor', color,...
	 'MarkerSize', param.markersize, 'Tag', 'selected',...
	 'HitTest', 'off', 'CLipping', 'off' );
else
  FF = vb_patch_select2( ind, F, length(V) );
  patch( 'Faces', FF, 'Vertices', V,...
	 'FaceColor', color, 'EdgeColor', 'none', 'FaceAlpha', 0.99,...
	 'Tag', 'selected', 'HitTest', 'off', 'Clipping', 'off' );
end




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% G[`
function Fnew = vb_patch_select2(Vix,F,Nvertex)
Itrans = zeros(Nvertex,1);
Itrans(Vix) = 1;
Fnew = Itrans(F);
ix = find(sum(Fnew,2));
Fnew = F(ix,:);
