function param = job_view_cortex_param( varargin )
% job_view_cortex_param
%
%  manage parameter setting window
%
% USAGE:
%  <new param> = job_view_cortex_param( <old param> );
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% СͤѤGUI
if nargin > 0
  param = varargin{1};
  parent = gcf;
  job_view_cortex_param_create_figure(parent);
  job_view_cortex_param_set_value_to_gui( param );
  % modalʥɥΥɥ UserData ץѥƥ
  % ѹޤԤġUserData ץѥƥϡOKܥ󤬲줿
  %  'ok' Cancelܥ󤬲줿 'cancel' Ǽ
  waitfor( gcf, 'UserData' );
  % UserData˳Ǽ줿 'ok' ʤСparam򹹿
  if strcmp( get( gcf, 'UserData' ), 'ok' )
    param = job_view_cortex_param_get_value_from_gui;
  else   % UserData˳Ǽ줿 'ok' ǤʤС֤
    param = [];
  end
  delete( gcf );
  return;
end


% ̵СХå


% ХåƤӽФ֥Ȥˤʬ
switch get( gcbo, 'Type' )
    
 case 'uicontrol'

  switch get( gcbo, 'Style' )

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   case 'radiobutton'

    set( findobj( gcf, 'Tag', get( gcbo, 'Tag' ) ), 'Value', 0 );
    set( gcbo, 'Value', 1 );

    switch get( gcbo, 'Tag' )

     case 'model_type'
      switch get( gcbo, 'UserData' )
       case 'original'
	set( findobj( gcf, 'Tag', 'sulcus_visibility' ), 'Enable', 'off' );
	set( findobj( gcf, 'Tag', 'sulcus_color' ), 'Visible', 'off' );
       case 'inflate'
	set( findobj( gcf, 'Tag', 'sulcus_visibility' ), 'Enable', 'on' );
	if get( findobj( gcf, 'Tag', 'sulcus_visibility',...
			 'UserData', 'visible' ), 'Value' )
	  set( findobj( gcf, 'Tag', 'sulcus_color' ), 'Visible', 'on' );
	else
	  set( findobj( gcf, 'Tag', 'sulcus_color' ), 'Visible', 'off' );
	end
      end
      
     case 'sulcus_visibility'
      switch get( gcbo, 'UserData' )
       case 'visible'
	set( findobj( gcf, 'Tag', 'sulcus_color' ), 'Visible', 'on' );
       case'invisible'
	set( findobj( gcf, 'Tag', 'sulcus_color' ), 'Visible', 'off' );
      end

     case 'paint'
      switch get( gcbo, 'UserData' )
       case 'dot'
	set( findobj( gcf, 'Tag', 'markersize' ), 'Enable', 'on' );
       case 'patch'
	set( findobj( gcf, 'Tag', 'markersize' ), 'Enable', 'off' );
      end

     case 'act_show_highlight'
      switch get( gcbo, 'UserData' )
       case 'on'
	set( findobj( gcf, 'Tag', 'act_non_highlight_alpha slider' ),...
	     'Enable', 'on' );
	set( findobj( gcf, 'Tag', 'act_non_highlight_alpha' ),...
	     'Enable', 'on' );
       case 'off'
	set( findobj( gcf, 'Tag', 'act_non_highlight_alpha slider' ),...
	     'Enable', 'off' );
	set( findobj( gcf, 'Tag', 'act_non_highlight_alpha' ),...
	     'Enable', 'off' );
      end

    end
    
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   case 'slider'

    switch get( gcbo, 'Tag' )
     case { 'area_alpha slider', 'act_non_highlight_alpha slider' }
      val = get( gcbo, 'Value' );
      val = round(val*100)/100.0;
      targetedit = findobj( gcf, 'Tag', strtok(get(gcbo,'Tag')) );
      if val >= 1
	set( targetedit, 'String', 0.99, 'UserData', 0.99 );
	set( gcbo, 'Value', 0.99 );
      elseif val == 0
	set( targetedit, 'String', 0.01, 'UserData', 0.01 );
	set( gcbo, 'Value', 0.01 );
      else
	set( targetedit, 'String', val, 'UserData', val );
	set( gcbo, 'Value', val );
      end
    end

   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   case 'edit'
    
    num = str2num( get( gcbo, 'String' ) );
    if isempty( num ) | num <= 0
      set( gcbo, 'String', get( gcbo, 'UserData' ) );
      return;
    end
    switch get( gcbo, 'Tag' )
     case { 'act_min', 'act_colormap_max', 'selection_radius',...
	    'dilation_erosion_radius' }
      set( gcbo, 'UserData', num );
     case 'selection_undo_length'
      if num < 1
	set( gcbo, 'UserData', 1, 'String', 1 );
      else
	set( gcbo, 'UserData', round(num), 'String', round(num) );
      end
     case { 'area_alpha', 'act_non_highlight_alpha' }
      if num < 0.01
	set( gcbo, 'UserData', 0.01, 'UserData', 0.01 );
	set( findobj( 'Tag', [get(gcbo,'Tag') ' slider'] ), 'Value', 0.01 );
      elseif num > 0.99
	set( gcbo, 'UserData', 0.99, 'String', 0.99 );
	set( findobj( 'Tag', [get(gcbo,'Tag') ' slider'] ), 'Value', 0.99 );
      else
	set( gcbo, 'UserData', round(num*100)/100.0,...
		       'String', round(num*100)/100.0 );
	set( findobj( 'Tag', [get(gcbo,'Tag') ' slider'] ),...
	     'Value', round(num*100)/100.0 );
      end
      
    end


   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   case 'pushbutton'
    set( gcf, 'UserData', get( gcbo, 'Tag' ) );

  end
  
  
 case 'patch'
  color = get( gcbo, 'FaceColor' );
  title = [ get( gcbo, 'Tag' ) ' setting' ];
  color = uisetcolor( color, title );
  set( gcbo, 'FaceColor', color );


end





%==========================================================================
%===  parameter ѤGUIι  ========================================
%==========================================================================

function H = job_view_cortex_param_create_figure(parent)

graycolor = [0.8 0.8 0.8];
whitecolor = [1 1 1];

figure( 'MenuBar', 'none', 'WindowStyle', 'modal', 'Units', 'pixels',...
	'NumberTitle', 'off', 'Name', 'Parameter Setting',...
	'CloseRequestFcn', 'set( gcf, ''UserData'', ''close'' );',...
	'Resize', 'off',...
	'DefaultUicontrolBackgroundColor', graycolor,...
	'DefaultUicontrolFontUnits', 'pixels',...
	'DefaultUicontrolFontSize', 12,...
	'DefaultUicontrolValue', 0,...
	'DefaultUicontrolHorizontalAlign', 'left',...
	'DefaultAxesUnits', 'pixels',...
	'DefaultAxesVisible', 'off',...
	'DefaultAxesXTick', [],	'DefaultAxesYTick', [] );
figpos = get( gcf, 'Position' );
fig_h = 645;
fig_w = 350;
screensize = get( 0, 'ScreenSize' );
if figpos(2) + fig_h > screensize(4)
  figpos(2) = screensize(4) - fig_h - 40;
end
set( gcf, 'Position', [ figpos(1), figpos(2), fig_w, fig_h ] );

label_l = 10;
label_w = 145;
line_h = 25;
value_l = label_l+label_w+10;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = 1;
uicontrol( 'Tag', 'LRflg label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Hemisphere to plot' );
uicontrol( 'Tag', 'LRflg', 'UserData', 'LR',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'LR',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'LRflg', 'UserData', 'L',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 35, 20 ],...
	   'Style', 'radiobutton', 'String', 'L',....
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'LRflg', 'UserData', 'R',...
	   'Position', [ value_l+90, fig_h-10-line_h*i, 35, 20 ],...
	   'Style', 'radiobutton', 'String', 'R',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'model_type label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Brain model type' );
uicontrol( 'Tag', 'model_type', 'UserData', 'original',...
	   'Position', [ value_l, fig_h-10-line_h*i, 70, 20 ],...
	   'Style', 'radiobutton', 'String', 'original',...
	   'Callback', 'job_view_cortex_param;' );
H = get(parent, 'UserData');
braindata = get(H.braindata, 'UserData');
if ~isempty(braindata.Vinflate)
    uicontrol( 'Tag', 'model_type', 'UserData', 'inflate',...
	   'Position', [ value_l+75, fig_h-10-line_h*i, 60, 20 ],...
	   'Style', 'radiobutton', 'String', 'inflate',...
	   'Callback', 'job_view_cortex_param;' );
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'sulcus_visibility label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Sulcus visibility' );
uicontrol( 'Tag', 'sulcus_visibility', 'UserData', 'visible',...
	   'Position', [ value_l, fig_h-10-line_h*i, 65, 20 ],...
	   'Style', 'radiobutton', 'String', 'visible',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'sulcus_visibility', 'UserData', 'invisible',...
	   'Position', [ value_l+70, fig_h-10-line_h*i, 75, 20 ],...
	   'Style', 'radiobutton', 'String', 'invisible',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'brain_color label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Color of brain / sulcus' );
axes( 'Tag', 'brain_color', 'HitTest', 'off',...
      'Position', [ value_l, fig_h-10-line_h*i, 20, 20 ] );
patch( 'Tag', 'brain_color',...
       'ButtonDownFcn', 'job_view_cortex_param;',...
       'XData',[0,1,1,0], 'YData',[0,0,1,1],...
       'Faces', [1,2,3,4], 'FaceColor',[1 1 1] );
uicontrol( 'Tag', 'brain_sulcus_border label', 'HitTest', 'off',...
	   'Position', [ value_l+25, fig_h-10-line_h*i, 10, 20 ],...
	   'Style', 'text', 'String', '/' );
axes( 'Tag', 'sulcus_color', 'HitTest', 'off',...
      'Position', [ value_l+45, fig_h-10-line_h*i, 20, 20 ] );
patch( 'Tag', 'sulcus_color',...
       'ButtonDownFcn', 'job_view_cortex_param;',...
       'XData',[0,1,1,0], 'YData',[0,0,1,1],...
       'Faces', [1,2,3,4], 'FaceColor',[1 1 1] );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'lighting label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Lighting' );
uicontrol( 'Tag', 'lighting', 'UserData', 'on',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'on',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'lighting', 'UserData', 'off',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'off',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_area_priority label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act / Area priority' );
uicontrol( 'Tag', 'act_area_priority', 'UserData', 'activation',...
	   'Position', [ value_l, fig_h-10-line_h*i, 85, 20 ],...
	   'Style', 'radiobutton', 'String', 'activation',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_area_priority', 'UserData', 'area',...
	   'Position', [ value_l+90, fig_h-10-line_h*i, 55, 20 ],...
	   'Style', 'radiobutton', 'String', 'area',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_normalize label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Activation normalize' );
uicontrol( 'Tag', 'act_normalize', 'UserData', 'no',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'no',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_normalize', 'UserData', 'meshsize',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 85, 20 ],...
	   'Style', 'radiobutton', 'String', 'mesh size',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_relative_mode label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Activation relative mode' );
uicontrol( 'Tag', 'act_relative_mode', 'UserData', 'each',...
	   'Position', [ value_l, fig_h-10-line_h*i, 55, 20 ],...
	   'Style', 'radiobutton', 'String', 'each',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_relative_mode', 'UserData', 'all',...
	   'Position', [ value_l+60, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'all',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_sign_mode label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. sign mode' );
uicontrol( 'Tag', 'act_sign_mode', 'UserData', 'signed',...
	   'Position', [ value_l, fig_h-10-line_h*i, 75, 20 ],...
	   'Style', 'radiobutton', 'String', 'signed',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_sign_mode', 'UserData', 'unsigned',...
	   'Position', [ value_l+80, fig_h-10-line_h*i, 80, 20 ],...
	   'Style', 'radiobutton', 'String', 'unsigned',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_min_mode label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. minimum mode' );
uicontrol( 'Tag', 'act_min_mode', 'UserData', 'absolute',...
	   'Position', [ value_l, fig_h-10-line_h*i, 75, 20 ],...
	   'Style', 'radiobutton', 'String', 'absolute',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_min_mode', 'UserData', 'relative',...
	   'Position', [ value_l+80, fig_h-10-line_h*i, 70, 20 ],...
	   'Style', 'radiobutton', 'String', 'relative',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_min label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. minimum value' );
uicontrol( 'Tag', 'act_min',...
	   'Position', [ value_l, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_colormap_max_mode label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. colormap max mode' );
uicontrol( 'Tag', 'act_colormap_max_mode', 'UserData', 'absolute',...
	   'Position', [ value_l, fig_h-10-line_h*i 75, 20 ],...
	   'Style', 'radiobutton', 'String', 'absolute',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_colormap_max_mode', 'UserData', 'relative',...
	   'Position', [ value_l+80, fig_h-10-line_h*i, 70, 20 ],...
	   'Style', 'radiobutton', 'String', 'relative',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_colormap_max label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. colormap max value' );
uicontrol( 'Tag', 'act_colormap_max',...
	   'Position', [ value_l, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_colormap_type label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. colormap type' );
uicontrol( 'Tag', 'act_colormap_type', 'UserData', 'hot',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'hot',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_colormap_type', 'UserData', 'jet',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'jet',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_show_highlight label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. show highlight' );
uicontrol( 'Tag', 'act_show_highlight', 'UserData', 'on',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'on',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'act_show_highlight', 'UserData', 'off',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'off',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'act_non_highlight_alpha label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. non highlihgt trans.' );
uicontrol( 'Tag', 'act_non_highlight_alpha slider',...
	   'Position', [ value_l, fig_h-10-line_h*i, 120, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'slider', 'Max', 1, 'Min', 0, 'SliderStep', [0.01 0.1] );
uicontrol( 'Tag', 'act_non_highlight_alpha',...
	   'Position', [ value_l+125, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'area_alpha label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Area transparency' );
uicontrol( 'Tag', 'area_alpha slider',...
	   'Position', [ value_l, fig_h-10-line_h*i, 120, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'slider', 'Max', 1, 'Min', 0, 'SliderStep', [0.01 0.1] );
uicontrol( 'Tag', 'area_alpha',...
	   'Position', [ value_l+125, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'area_show_highlight label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Act. show highlight' );
uicontrol( 'Tag', 'area_show_highlight', 'UserData', 'on',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'on',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'area_show_highlight', 'UserData', 'off',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'off',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'selection_radius label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Selection radius' );
uicontrol( 'Tag', 'selection_radius',...
	   'Position', [ value_l, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'selection_color label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Color of vertex selection' );
axes( 'Tag', 'selection_color',...
      'Position', [ value_l, fig_h-10-line_h*i, 20, 20 ] );
patch( 'Tag', 'selection_color',...
       'ButtonDownFcn', 'job_view_cortex_param;',...
       'XData',[0,1,1,0], 'YData',[0,0,1,1],...
       'Faces', [1,2,3,4], 'FaceColor',[1 1 1] );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'selection_undo_length label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Selection undo length' );
uicontrol( 'Tag', 'selection_undo_length',...
	   'Position', [ value_l, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'dilation_erosion_radius label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Dilation / Erosion radius' );
uicontrol( 'Tag', 'dilation_erosion_radius',...
	   'Position', [ value_l, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'paint label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Painting method' );
uicontrol( 'Tag', 'paint', 'UserData', 'dot',...
	   'Position', [ value_l, fig_h-10-line_h*i, 45, 20 ],...
	   'Style', 'radiobutton', 'String', 'dot',...
	   'Callback', 'job_view_cortex_param;' );
uicontrol( 'Tag', 'paint', 'UserData', 'patch',...
	   'Position', [ value_l+50, fig_h-10-line_h*i, 60, 20 ],...
	   'Style', 'radiobutton', 'String', 'patch',...
	   'Callback', 'job_view_cortex_param;' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'markersize label', 'HitTest', 'off',...
	   'Position', [ label_l, fig_h-10-line_h*i+1, label_w, 16 ],...
	   'Style', 'text', 'String', 'Dot marker size' );
uicontrol( 'Tag', 'markersize',...
	   'Position', [ value_l, fig_h-10-line_h*i, 40, 20 ],...
	   'Callback', 'job_view_cortex_param;',...
	   'Style', 'edit', 'BackgroundColor', whitecolor,...
	   'HorizontalAlign', 'right' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i = i + 1;
uicontrol( 'Tag', 'ok',...
	   'Position', [ fig_w-110, fig_h-10-line_h*i, 40, 20 ],...
	   'Style', 'pushbutton', 'String', 'OK',...
	   'HorizontalAlign', 'center',...
	   'Callback', 'job_view_cortex_param;' );

uicontrol( 'Tag', 'cancel',...
	   'Position', [ fig_w-65, fig_h-10-line_h*i, 55, 20 ],...
	   'Style', 'pushbutton', 'String', 'Cancel',...
	   'HorizontalAlign', 'center',...
	   'Callback', 'job_view_cortex_param;' );



%==========================================================================
%===  param ͤGUI˥åȤ  ========================================
%==========================================================================

function job_view_cortex_param_set_value_to_gui( param )

fns = fieldnames( param );

for i = 1 : length( fns )
  fn = fns{i};
  val = getfield( param, fn );
  if isstr( val )
    set( findobj( gcf, 'Tag', fn, 'UserData', val ), 'Value', 1 );
  elseif length( val ) == 3
    set( findobj( gcf, 'Tag', fn, 'Type', 'patch' ), 'FaceColor', val );
  else
    set( findobj( gcf, 'Tag', fn ), 'String', val, 'UserData', val );
  end
end

set( findobj( gcf, 'Tag', 'area_alpha slider' ), 'Value', param.area_alpha );
set( findobj( gcf, 'Tag', 'act_non_highlight_alpha slider' ),...
     'Value', param.act_non_highlight_alpha );




%==========================================================================
%===  GUIꤷͤ param ˼  =================================
%==========================================================================

function param = job_view_cortex_param_get_value_from_gui

target = findobj( gcf, 'Tag', 'LRflg', 'Value', 1 );
param.LRflg = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'model_type', 'Value', 1 );
param.model_type = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'sulcus_visibility', 'Value', 1 );
param.sulcus_visibility = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'brain_color', 'Type', 'patch' );
param.brain_color = get( target, 'FaceColor' );

target = findobj( gcf, 'Tag', 'sulcus_color', 'Type', 'patch' );
param.sulcus_color = get( target, 'FaceColor' );

target = findobj( gcf, 'Tag', 'lighting', 'Value', 1 );
param.lighting = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_area_priority', 'Value', 1 );
param.act_area_priority = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_relative_mode', 'Value', 1 );
param.act_relative_mode = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_normalize', 'Value', 1 );
param.act_normalize = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_sign_mode', 'Value', 1 );
param.act_sign_mode = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_min_mode', 'Value', 1 );
param.act_min_mode = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_min', 'Style', 'edit' );
param.act_min = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_colormap_max_mode', 'Value', 1 );
param.act_colormap_max_mode = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_colormap_max', 'Style', 'edit' );
param.act_colormap_max = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_relative_mode', 'Value', 1 );
param.act_relative_mode = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_colormap_type', 'Value', 1 );
param.act_colormap_type = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_show_highlight', 'Value', 1 );
param.act_show_highlight = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'act_non_highlight_alpha', 'Style', 'edit' );
param.act_non_highlight_alpha = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'area_alpha', 'Style', 'edit' );
param.area_alpha = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'area_show_highlight', 'Value', 1 );
param.area_show_highlight = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'selection_radius', 'Style', 'edit' );
param.selection_radius = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'selection_color', 'Type', 'patch' );
param.selection_color = get( target, 'FaceColor' );

target = findobj( gcf, 'Tag', 'selection_undo_length', 'Style', 'edit' );
param.selection_undo_length = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'dilation_erosion_radius', 'Style', 'edit' );
param.dilation_erosion_radius = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'paint', 'Value', 1 );
param.paint = get( target, 'UserData' );

target = findobj( gcf, 'Tag', 'markersize', 'Style', 'edit' );
param.markersize = get( target, 'UserData' );



