function job_view_cortex_aftereffect( key )
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

H = get( gcf, 'UserData' );

switch key

 %--------------------------------------------------------------------
 case 'file load brain'
  data = get( H.braindata, 'UserData' );
  [ p n e ] = fileparts( data.filename );
  set( H.brain_file_name, 'String', [ n e ] );
  set( H.activation_file_load_button, 'Enable', 'on' );
  set( H.area_file_load_button, 'Enable', 'on' );
  
 case 'file load act'
  data = get( H.actdata, 'UserData' );
  [ p n e ] = fileparts( data.filename );
  set( H.activation_file_name, 'String', [ n e ] );
  set( H.activation_plotted_add_button, 'Enable', 'off' );
  set( H.activation_list, 'Value', [] );
  set( H.activation_list, 'String', { data.source(data.candidate).key } );
  job_view_cortex_list( 'clear', 'act', 'plotted' );
  job_view_cortex_aftereffect( 'list act plotted delete' );

 case 'file load area'
  data = get( H.areadata, 'UserData' );
  [ p n e ] = fileparts( data.filename );
  set( H.area_file_name, 'String', [ n e ] );
  set( H.area_plotted_add_button, 'Enable', 'off' );
  set( H.area_masking_add_button, 'Enable', 'off' );
  set( H.area_list, 'Value', [] );
  set( H.area_list, 'String', { data.source(data.candidate).key } );
  job_view_cortex_list( 'clear', 'area', 'plotted' );
  job_view_cortex_aftereffect( 'list area plotted delete' );
  job_view_cortex_list( 'clear', 'area', 'masking' );
  job_view_cortex_aftereffect( 'list area masking delete' );

 case 'file save area'
  data = get( H.areadata, 'UserData' );
  [ p n e ] = fileparts( data.filename );
  set( H.area_file_name, 'String', [ n e ] );
  set( H.area_file_save_button, 'Enable', 'off' );
  


 %--------------------------------------------------------------------
 case 'list act candidate select'
  set( H.activation_plotted_add_button, 'Enable', 'on' );
  
 case 'list act plotted select'
  set( H.activation_plotted_delete_button, 'Enable', 'on' );
  
 case 'list act plotted unselect'
  set( H.activation_plotted_delete_button, 'Enable', 'off' );
  
 case 'list act plotted add'
  data = get( H.actdata, 'UserData' );
  set( H.activation_plotted_list, 'Value', [] );
  set( H.activation_plotted_list, 'String', { data.source(data.plotted).key } );
  selected = get( H.activation_list, 'Value' );
  set( H.activation_plotted_list, 'Value', find( ismember( data.plotted, selected ) ) );
  set( H.activation_plotted_delete_button, 'Enable', 'on' );
  set( H.activation_plotted_clear_button, 'Enable', 'on' );
  set( H.selection_add_intersect_act_button, 'Enable', 'on' );
  set( H.selection_add_union_act_button, 'Enable', 'on' );
  set( H.selection_delete_intersect_act_button, 'Enable', 'on' );
  set( H.selection_delete_union_act_button, 'Enable', 'on' );
  
 case 'list act plotted delete'
  data = get( H.actdata, 'UserData' );
  set( H.activation_plotted_list, 'Value', [] );
  set( H.activation_plotted_list, 'String', { data.source(data.plotted).key } ); 
  set( H.activation_plotted_delete_button, 'Enable', 'off' );
  if isempty( data.plotted )
    set( H.activation_plotted_clear_button, 'Enable', 'off' );
    set( H.selection_add_intersect_act_button, 'Enable', 'off' );
    set( H.selection_add_union_act_button, 'Enable', 'off' );
    set( H.selection_delete_intersect_act_button, 'Enable', 'off' );
    set( H.selection_delete_union_act_button, 'Enable', 'off' );
  end


 %--------------------------------------------------------------------
 case 'list area candidate select'
  set( H.area_plotted_add_button, 'Enable', 'on' );
  set( H.area_masking_add_button, 'Enable', 'on' );
  set( H.area_list_delete_button, 'Enable', 'on' );
  
 case 'list area candidate delete'
  job_view_cortex_aftereffect( 'list area plotted delete' );
  job_view_cortex_aftereffect( 'list area masking delete' );
  data = get( H.areadata, 'UserData' );
  set( H.area_list, 'Value', [] );
  set( H.area_list, 'String', { data.source(data.candidate).key } );
  set( H.area_list_delete_button, 'Enable', 'off' );
  set( H.area_file_save_button, 'Enable', 'on' );
  set( H.area_plotted_add_button, 'Enable', 'off' );
  set( H.area_masking_add_button, 'Enable', 'off' );

 case 'list area plotted select'
  set( H.area_plotted_delete_button, 'Enable', 'on' );
  
 case 'list area plotted unselect'
  set( H.area_plotted_delete_button, 'Enable', 'off' );
  
 case 'list area plotted add'
  data = get( H.areadata, 'UserData' );
  set( H.area_plotted_list, 'Value', [] );
  set( H.area_plotted_list, 'String', { data.source(data.plotted).key } );
  selected = get( H.area_list, 'Value' );
  set( H.area_plotted_list, 'Value', find( ismember( data.plotted, selected ) ) );
  set( H.area_plotted_delete_button, 'Enable', 'on' );
  set( H.area_plotted_clear_button, 'Enable', 'on' );
  set( H.selection_add_intersect_area_button, 'Enable', 'on' );
  set( H.selection_add_union_area_button, 'Enable', 'on' );
  set( H.selection_delete_intersect_area_button, 'Enable', 'on' );
  set( H.selection_delete_union_area_button, 'Enable', 'on' );
  
 case 'list area plotted delete'
  data = get( H.areadata, 'UserData' );
  set( H.area_plotted_list, 'Value', [] );
  set( H.area_plotted_list, 'String', { data.source(data.plotted).key } ); 
  set( H.area_plotted_delete_button, 'Enable', 'off' );
  if isempty( data.plotted )
    set( H.area_plotted_clear_button, 'Enable', 'off' );
    set( H.selection_add_intersect_area_button, 'Enable', 'off' );
    set( H.selection_add_union_area_button, 'Enable', 'off' );
    set( H.selection_delete_intersect_area_button, 'Enable', 'off' );
    set( H.selection_delete_union_area_button, 'Enable', 'off' );
  end

 case 'list area masking select'
  set( H.area_masking_delete_button, 'Enable', 'on' );
  
 case 'list area plotted unselect'
  set( H.area_masking_delete_button, 'Enable', 'off' );
  
 case 'list area masking add'
  data = get( H.areadata, 'UserData' );
  set( H.area_masking_list, 'Value', [] );
  set( H.area_masking_list, 'String', { data.source(data.masking).key } );
  selected = get( H.area_list, 'Value' );
  set( H.area_masking_list, 'Value', find( ismember( data.masking, selected ) ) );
  set( H.area_masking_delete_button, 'Enable', 'on' );
  set( H.area_masking_clear_button, 'Enable', 'on' );
  
 case 'list area masking delete'
  data = get( H.areadata, 'UserData' );
  set( H.area_masking_list, 'Value', [] );
  set( H.area_masking_list, 'String', { data.source(data.masking).key } ); 
  set( H.area_masking_delete_button, 'Enable', 'off' );
  if isempty( data.masking )
    set( H.area_masking_clear_button, 'Enable', 'off' );
  end


 %--------------------------------------------------------------------
 case 'selection add'
  data = get( H.selectdata, 'UserData' );
  set( H.selection_num_vertex, 'String', length(data.Vi) );
  set( H.selection_clear_button, 'Enable', 'on' );
  set( H.selection_register_button, 'Enable', 'on' );
  set( H.selection_dilation_button, 'Enable', 'on' );
  set( H.selection_erosion_button, 'Enable', 'on' );
  set( H.selection_undo_button, 'Enable', 'on' );
  
 case 'selection delete'
  data = get( H.selectdata, 'UserData' );
  set( H.selection_num_vertex, 'String', length(data.Vi) );
  if isempty( data.Vi )
    set( H.selection_clear_button, 'Enable', 'off' );
    set( H.selection_register_button, 'Enable', 'off' );
    set( H.selection_dilation_button, 'Enable', 'off' );
    set( H.selection_erosion_button, 'Enable', 'off' );
    set( H.selection_undo_button, 'Enable', 'on' );
  end

 case 'selection undo'
  data = get( H.selectdata, 'UserData' );
  set( H.selection_num_vertex, 'String', length(data.Vi) );
  if isempty( data.history )
    set( H.selection_undo_button, 'Enable', 'off' );
  end

 case 'selection register'
  data = get( H.areadata, 'UserData' );
  set( H.area_list, 'String', { data.source(data.candidate).key } );
  set( H.area_list_delete_button, 'Enable', 'on' );
  set( H.area_file_save_button, 'Enable', 'on' );



 %--------------------------------------------------------------------

end
