function job_select_area(brainfile,areafile,actfile,mode)
% By using this, you can look the original or inflated brain model
% with an activity map and/or area data. 
% Usage: job_select_area(brainfile, areafile, actfile, mode)
%
% [IN]
%    brainfile : Brain model filename (.brain.mat) 
%    areafile  : Area data filename (.area.mat) 
%    actfile   : Activity map file (.act.mat) 
%    mode      : Display mode (0: original, 1: inflate <Default>) 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<4, mode=1; end;

parm.brainfile = brainfile;
parm.areafile = areafile;
parm.actfile = actfile;
parm.mode = mode;
plot_parm = vb_set_plot_parm;
vb_select_area(parm, plot_parm);
