function job_plot_meg_print_timecourse(inst_id)
% Print temporal pattern of MEG signal. Invoked by job_plot_meg.
%
% [syntax]
% job_plot_meg_print_temporalpattern(inst_id)
%
% [history]
% 2008-12-09 Taku Yoshioka
% 2011-01-18 taku-y
%  [minor] Printing properties got by vb_property_dlg. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotmeg{inst_id}.bexp), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
T           = vbmeg_inst.plotmeg{inst_id}.T;
N           = vbmeg_inst.plotmeg{inst_id}.N;
t           = vbmeg_inst.plotmeg{inst_id}.t;
n_trial     = vbmeg_inst.plotmeg{inst_id}.n_trial;
MEGinfo     = vbmeg_inst.plotmeg{inst_id}.MEGinfo;
rb1         = vbmeg_inst.plotmeg{inst_id}.rb1;
ed5         = vbmeg_inst.plotmeg{inst_id}.ed5;
sensor_type = vbmeg_inst.plotmeg{inst_id}.sensor_type;

%
% Get sensor indices
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if sensor_type~=-1, 
  ix = find(MEGinfo.ChannelInfo.Type==sensor_type);
  N = length(ix);
else
  ix = 1:(size(vbmeg_inst.plotmeg{inst_id}.bexp(:,:,n_trial),1));
end

%
% Figure property dialog
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
property_names = {'Show TOI','xlim','ylim'};
xx = [ceil(min(T)) ceil(max(T))];
if get(rb1,'Value')==1, 
  tmp = vbmeg_inst.plotmeg{inst_id}.bexp(ix,:,n_trial);
  yy = max(sqrt(sum(tmp.^2,1)));
  yy = ceil(yy/(10^(floor(log10(yy))-1)))*(10^(floor(log10(yy))-1));
  yy = [0 yy];
else
  yy = max(max(abs(vbmeg_inst.plotmeg{inst_id}.bexp(ix,:,n_trial))));
  yy = ceil(yy/(10^(floor(log10(yy))-1)))*(10^(floor(log10(yy))-1));
  yy = [-yy yy];
end
default_values = {'1',num2str(xx),num2str(yy)};
description    ...
    = {'Show TOI (1) or not (0)', ...
       'Start and end of time course', ...
       'Min and max of signal'};
values = vb_property_dlg(property_names,default_values,description);

if isempty(values),
  return;
end

is_toi = str2num(values{1});
xx     = str2num(values{2});
yy     = str2num(values{3});

if xx(1)>xx(2), 
  tmp = xx(1);
  xx(1) = xx(2);
  xx(2) = tmp;
end

if yy(1)>yy(2), 
  tmp = yy(1);
  yy(1) = yy(2);
  yy(2) = tmp;
end

%
% Print temporal pattern
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h = figure; 

if get(rb1,'Value')==1, 
  tmp = vbmeg_inst.plotmeg{inst_id}.bexp(ix,:,n_trial);
  plot(T,sqrt(sum(tmp.^2,1)),'LineWidth',2);
else
  plot(repmat(T,[N 1])',...
       vbmeg_inst.plotmeg{inst_id}.bexp(ix,:,n_trial)');
end

xlim(xx);
ylim(yy);
%xlim([min(T) max(T)]);
set(gca,'FontSize',13.5);
xlabel('Time [ms]','FontSize',13.5);
ylabel('MEG signal [fT]','FontSize',13.5);
pos = get(gca,'Position');
set(gca,'Position',[pos(1) pos(2)+0.05 pos(3) pos(4)-0.05]);
hold on;

if is_toi, 
  y = ylim;
  X = [t(1) t(2) t(2) t(1) t(1)];
  Y = [y(1) y(1) y(2) y(2) y(1)];
  set(gca,'YLimMode','manual');
  plot(X,Y,'k','LineWidth',0.5);
end

% Print figure
vb_epsfig(h,0.5,15);

[fig_dir,fig_file] = vb_file_select({'.eps'},'Save figure',true);

if ~isempty(fig_file), 
  figfile = [fig_dir filesep fig_file{1}];
  print(h,'-depsc',figfile);
end

close(h);

return;
