function job_plot_cmap_update_filterradius(inst_id)
% Processing required when updating filter radius
% 
% [syntax]
% job_plot_cmap_update_filterradius(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-01 Taku Yoshioka
% 2010-12-09 taku-y
% [internal change] job_plot_cmap_gauss_filter was replaced by
%                   vb_spatial_gauss_filter. 
% 2012-02-17 taku-y
% [minor] brainfile -> brain_file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig      = vbmeg_inst.plotcmap{inst_id}.h_fig;
ed5        = vbmeg_inst.plotcmap{inst_id}.ed5; 
brain_file = vbmeg_inst.plotcmap{inst_id}.brain_file;

% Filter radius check
Rfilt = 1e-3*str2num(get(ed5,'String'));
if Rfilt<0, Rfilt=0; end;
vbmeg_inst.plotcmap{inst_id}.Rfilt = Rfilt;

% Update GUI component
set(ed5,'String',num2str(Rfilt*1e3));

%
% Filter calculation
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'Pointer','watch');
drawnow;
ix_all = 1:length(vbmeg_inst.plotcmap{inst_id}.nextDD);

% Rfilt=10000. In practice, this gives uniform value inside of the
% radius. 
W = vb_spatial_gauss_filter(brain_file,10000,Rfilt,ix_all,0);

vbmeg_inst.plotcmap{inst_id}.W = W;
set(h_fig,'Pointer','arrow');

return;
