function [result] = job_plot_cmap_setting_dlg_set_file(H, file, file_type)
% set file to GUI.
% [USAGE]
%    [result] = job_plot_cmap_setting_dlg_set_file(H, file, file_type);
% [IN]
%            H : graphics handles             <<struct>>
%         file : fullpath filename.           <<string>>
%    file_type : file type of specified file. <<string>>
%                = 'brain_file'    : cortical model file(.brain.mat)
%                = 'area_file'     : cortical area file(.area.mat)
%                = 'act_file'      : cortical act file(.act.mat)
%                = 'current_file'  : cortical current file(.curr.mat)
%                = 'tf_file'       : time frequency file(.tf.mat)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('H', 'var')
    error('H is a required parameter.');
end
if ~exist('file', 'var')
    error('file is a required parameter.');
end
if ~exist('file_type', 'var')
    error('file_type is a required parameter.');
end

%
% --- Main Procedure
%
result = SUCCESS;

ext = '';
d = vb_define_extension;

switch(file_type)
    case 'brain_file'
        ext = d.BRAIN_EXTENSION;
        comp_edit  = H.brain_file_edit;
        comp_check = H.brain_file_update_checkbox;
    case 'area_file'
        ext = d.AREA_EXTENSION;
        comp_edit = H.area_file_edit;
        comp_check = H.area_file_update_checkbox;
    case 'act_file'
        ext = d.FMRI_EXTENSION;
        comp_edit = H.act_file_edit;
        comp_check = H.act_file_update_checkbox;
    case 'current_file'
        ext = d.CURRENT_EXTENSION;
        comp_edit = H.current_file_edit;
        comp_check = H.current_file_update_checkbox;
    case 'tf_file'
        ext = '.tf.mat';
        comp_edit = H.tf_file_edit;
        comp_check = H.tf_file_update_checkbox;
    otherwise
        error('Specified file_type is unknown.');
end

%
% --- File validity check
%
if isempty(file)
    file = getappdata(comp_edit, 'prev');
    set(comp_edit, 'String', file);
    return;
end

if exist(file, 'file') ~= 2
%    set(comp_check, 'Value', 0);
    result = FAILURE;
    return;
end

% no filename
if length(file) < length(ext)
    result = FAILURE;
    return;
end

% extension check
if ~strcmpi(file(end-length(ext)+1:end), ext)
    result = FAILURE;
    return;
end

% Set filename
set(comp_edit, 'String', file);
% remember file as a previous collect input(currently unused information)
setappdata(comp_edit, 'prev', file);
% update checkbox ON
set(comp_check, 'Value', 1);
