function job_plot_cmap_selvertex(inst_id)
% Find nearest vertex from the selected point on GUI.
% 
% [syntax]
% job_plot_cmap_selvertex(inst_id)
%
% [history]
% 2008-09-02 Taku Yoshioka
% 2011-02-16 taku-y
%  [enhancement] Show area list including selected vertex. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rb        = vbmeg_inst.plotcmap{inst_id}.model_type_original_rb;
%lb3       = vbmeg_inst.plotcmap{inst_id}.lb3;
%area_file = vbmeg_inst.plotcmap{inst_id}.area_file;

%
% Cortical surface model displayed
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if get(rb,'Value')
    V = vbmeg_inst.plotcmap{inst_id}.V; 
else
    V = vbmeg_inst.plotcmap{inst_id}.Vinf;
end

%
% Vertex selection
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
p = (select3d)';
if length(p)==0, return; end; 
tmp = repmat(p,[size(V,1) 1]);
[tmp ixp] = min(sum((tmp-V).^2,2));
vbmeg_inst.plotcmap{inst_id}.ix_peak = ixp;

h = msgbox('Please wait...');
drawnow;
% %
% % Update cortical area list
% %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% if ~isempty(area_file),
%   area_key      = vb_get_keyset_area(area_file);
%   area_key_list = []; %cell(0,0);
%   n = 1;
%   
%   for i=1:length(area_key)
%     tmp = vb_get_area(area_file,area_key{i});
%     if ~isempty(find(tmp.Iextract==ixp)),
%       area_key_list{n} = tmp.key;
%       n = n+1;
%     end
%     
%     set(lb3,'String',area_key_list, 'Value', 1);
%   end
% end

%
% Update figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id);

if ishandle(h)
    delete(h);
end

