function job_plot_cmap_load_data(inst_id,parms)
% Open file dialog and load data.
%
% [syntax]
% job_plot_cmap_load_data(inst_id,parms)
%
% [input]
% inst_id: ID of instant of job_plot_currentmap GUI.
% parms  : <optional> <<struct>> Replaces brain_file, curr_file,
%          area_file, act_file, tf_file, ix_trial and ave_mode if these
%          fields exist in this struct.
%
% [history]
% 2012-02-20 taku-y
% 2012-02-28 taku-y
%  [minor] File dialog was modified to recognize input arguments as
%  default value of the file names and trial index. 
% 2012-03-08 taku-y
%  [major] The file dialog was renewed refs #198. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

% handle of GUI components
h_fig = vbmeg_inst.plotcmap{inst_id}.h_fig;
ed1   = vbmeg_inst.plotcmap{inst_id}.ed1; 

% check existing files
brain_file = vbmeg_inst.plotcmap{inst_id}.brain_file;
curr_file  = vbmeg_inst.plotcmap{inst_id}.curr_file;
tf_file    = vbmeg_inst.plotcmap{inst_id}.tf_file;
area_file  = vbmeg_inst.plotcmap{inst_id}.area_file;
act_file   = vbmeg_inst.plotcmap{inst_id}.act_file;
ix_trial   = vbmeg_inst.plotcmap{inst_id}.ix_trial;
ave_mode   = vbmeg_inst.plotcmap{inst_id}.ave_mode;

% file dialog parameter
filedlg_mode = vbmeg_inst.plotcmap{inst_id}.filedlg_mode;

% input arguments
if nargin<2, parms = []; end

% dialog properties (input of job_plot_cmap_setting_dlg)
props_in = [];

% dialog property: brain_file
p.key = 'brain_file';

if ~isempty(brain_file), 
  p.value       = brain_file;
  p.update_flag = false;
elseif isfield(parms,'brain_file'), 
  p.value       = parms.brain_file;
  p.update_flag = true;
else
  p.value       = '';
  p.update_flag = false;
end

props_in = vb_table_insert(props_in,p);

% dialog property: area_file
p.key = 'area_file';

if ~isempty(area_file), 
  p.value       = area_file;
  p.update_flag = false;
elseif isfield(parms,'area_file'), 
  p.value       = parms.area_file;
  p.update_flag = true;
else
  p.value       = '';
  p.update_flag = false;
end

props_in = vb_table_insert(props_in,p);

% dialog property: act_file
p.key = 'act_file';

if ~isempty(act_file), 
  p.value       = act_file;
  p.update_flag = false;
elseif isfield(parms,'act_file'), 
  p.value       = parms.act_file;
  p.update_flag = true;
else
  p.value       = '';
  p.update_flag = false;
end

props_in = vb_table_insert(props_in,p);

% dialog property: current_file
p.key = 'current_file';

if ~isempty(curr_file), 
  p.value       = curr_file;
  p.update_flag = false;
elseif isfield(parms,'curr_file'), 
  p.value       = parms.curr_file;
  p.update_flag = true;
else
  p.value       = '';
  p.update_flag = false;
end

props_in = vb_table_insert(props_in,p);

% dialog property: ave_mode
p.key = 'current_load_mode';

if isfield(parms,'ave_mode'), 
  ave_mode      = parms.ave_mode;
  p.update_flag = true;
else
  p.update_flag = false;
end

if ave_mode,
  ave_mode_str = 'ave';
else
  ave_mode_str = 'raw';
end

p.value = ave_mode_str;

props_in = vb_table_insert(props_in,p);

% dialog property: ix_trial
p.key = 'current_trial';

if isfield(parms,'ix_trial'), 
  p.value       = parms.ix_trial;
  p.update_flag = true;
else
  p.value       = ix_trial;
  p.update_flag = false;
end

if strcmp(ave_mode_str,'ave') & p.value>=2, 
  p.value       = 1;
  p.update_flag = true;
end

p.value = ceil(p.value);
if isstr(p.value) | isempty(p.value) | length(p.value)>1, 
  vb_disp(['Trial index must be an integer value. Forced ix_trial to ' ...
           'be 1 (in job_plot_cmap_load_data.m). '], 'WARNING');
  p.value = 1;
end

props_in = vb_table_insert(props_in,p);

% dialog property: tf_file
p.key = 'tf_file';

if ~isempty(tf_file), 
  p.value       = tf_file;
  p.update_flag = false;
elseif isfield(parms,'tf_file'), 
  p.value       = parms.tf_file;
  p.update_flag = true;
else
  p.value       = '';
  p.update_flag = false;
end

props_in = vb_table_insert(props_in,p);

% open dialog
props_out = job_plot_cmap_setting_dlg(props_in,filedlg_mode);

% load cortical surface model
update_flag = vb_table_query_update_flag(props_out,'brain_file');

if update_flag,
  brain_file = vb_table_query_value(props_out,'brain_file');
else
  brain_file = '';
end

if ~isempty(brain_file),
  set(h_fig,'Pointer','watch');
  drawnow; 

  vbmeg_inst.plotcmap{inst_id}.brain_file = brain_file;
  
  % cortical surface model
  [Vinf,F,xx,inf_C,xxA] = vb_load_cortex(brain_file,'Inflate');
  V = vb_load_cortex(brain_file);
  vbmeg_inst.plotcmap{inst_id}.V = V;
  vbmeg_inst.plotcmap{inst_id}.Vinf = Vinf;
  vbmeg_inst.plotcmap{inst_id}.F = F;
  vbmeg_inst.plotcmap{inst_id}.inf_C = inf_C;
  vbmeg_inst.plotcmap{inst_id}.xxA = xxA;
  
  % Standard brain coordinate
  Vtal = vb_load_cortex(brain_file,'Talairach');
  Vmni = vb_load_cortex(brain_file,'MNI');
  if ~exist('Vtal','var') || isempty(Vtal), Vtal = zeros(size(V)); end
  if ~exist('Vmni','var') || isempty(Vmni), Vmni = zeros(size(V)); end
  vbmeg_inst.plotcmap{inst_id}.Vtal = Vtal*1e3;
  vbmeg_inst.plotcmap{inst_id}.Vmni = Vmni*1e3;
  
  % Load neighbour data for filter calculation
  [nextDD,nextIX] = vb_load_cortex_neighbour(brain_file); 
  vbmeg_inst.plotcmap{inst_id}.nextDD = nextDD;
  vbmeg_inst.plotcmap{inst_id}.nextIX = nextIX;

  set(h_fig,'Pointer','arrow');
  vb_disp('Cortical surface file loaded: job_plot_cmap_load_data', ...
          'DEBUG');

end

% load current data
update_flag = vb_table_query_update_flag(props_out,'current_file');

if update_flag, 
  curr_file = vb_table_query_value(props_out,'current_file');
else
  curr_file = '';
end

if ~isempty(curr_file),
  vbmeg_inst.plotcmap{inst_id}.curr_file = curr_file;
  
  % clear time-frequency variables
  vbmeg_inst.plotcmap{inst_id}.tf_file    = [];
  vbmeg_inst.plotcmap{inst_id}.data       = [];
  vbmeg_inst.plotcmap{inst_id}.TFmax      = [];
  vbmeg_inst.plotcmap{inst_id}.TFmin      = [];
  vbmeg_inst.plotcmap{inst_id}.TFmax_plot = [];
  vbmeg_inst.plotcmap{inst_id}.TFmin_plot = [];
  vbmeg_inst.plotcmap{inst_id}.foi        = [];
  vbmeg_inst.plotcmap{inst_id}.TFinfo     = [];
  
  % load Jinfo (header of current data)
  set(h_fig,'Pointer','watch');
  drawnow;
  Jinfo = vb_load_current_info(curr_file);
  vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
  set(h_fig,'Pointer','arrow');
  
  % average mode
  ave_mode_str = vb_table_query_value(props_out,'current_load_mode');

  if strcmp(ave_mode_str,'ave'), 
    ave_mode = true;
  elseif Jinfo.Ntrial==1, 
    ave_mode = true;
  else
    ave_mode = false;
  end
  
  if ave_mode,
    set(ed1,'Enable','off');
  else
    set(ed1,'Enable','on');
  end
  vbmeg_inst.plotcmap{inst_id}.ave_mode = ave_mode;
  
  % trial index
  ix_trial = vb_table_query_value(props_out,'current_trial');
  
  %if ix_trial>Jinfo.Ntrial
  %  ix_trial = 1;
  %  % some message of this overwrite should be helpful
  %end

  vbmeg_inst.plotcmap{inst_id}.ix_trial = ix_trial;
  set(ed1,'String',num2str(ix_trial));
  
  % load current data
  set(h_fig,'Pointer','watch');
  drawnow; 
  [tmp,Jact] = vb_load_current(curr_file,0,ave_mode,ix_trial);
  set(h_fig,'Pointer','arrow');
  if ~isempty(vbmeg_inst.plotcmap{inst_id}.V), 
    if max(Jinfo.ix_act_ex)>size(vbmeg_inst.plotcmap{inst_id}.V,1), 
      warndlg(['Index of dipole currents exceeds the number of ' ...
               'vertices.']);
      return;
    end
  end

  % dipole current direction is flipped to inward
  vbmeg_inst.plotcmap{inst_id}.Jact = -1*Jact;
  clear Jact;
  
  % plotcmap.ix_act was obsoleted
  if ~isfield(Jinfo,'version') || ...
        vb_version_cmp(Jinfo.version,'<','0.9-0.a.0'),
    if isfield(Jinfo,'ix_act_ex'), 
      vbmeg_inst.plotcmap{inst_id}.ix_act = Jinfo.ix_act_ex;
    else
      vbmeg_inst.plotcmap{inst_id}.ix_act = Jinfo.ix_act;
    end
  end

  % background current is not supported. 
  vbmeg_inst.plotcmap{inst_id}.Jbck = [];
  vbmeg_inst.plotcmap{inst_id}.ix_bck = [];

  % temporal information
  if isfield(Jinfo,'version') & ...
        vb_version_cmp(Jinfo.version,'>=','0.9-0.a.0'), 
    T = Jinfo.Tmsec;
    vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
  else
    load(curr_file,'MEGinfo');
    if exist('MEGinfo'), 
      T = (1000/MEGinfo.SampleFreq) ...
          *(Jinfo.Tsample-vb_meginfo_get_pre_trigger(MEGinfo));
      if exist('Jinfo'), 
        vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
      else
        vbmeg_inst.plotcmap{inst_id}.Jinfo = MEGinfo;
      end
      vbmeg_inst.plotcmap{inst_id}.Jinfo.version = '0.7';
      vbmeg_inst.plotcmap{inst_id}.Tstart = Jinfo.Tsample(1);
    else
      T = Jinfo.Tmsec;
      vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
      vbmeg_inst.plotcmap{inst_id}.Jinfo.version = '0.7';
      vbmeg_inst.plotcmap{inst_id}.Tstart = Jinfo.Tsample(1);
    end
  end

  vbmeg_inst.plotcmap{inst_id}.toi = [90 100];

  % other parameters
  if isfield(Jinfo,'patch_norm'), 
    vbmeg_inst.plotcmap{inst_id}.Jinfo.patch_norm = Jinfo.patch_norm;
  else
    if isfield(Jinfo,'bayes_parm') ...
          & isfield(Jinfo.bayes_parm,'patch_norm'), 
      vbmeg_inst.plotcmap{inst_id}.Jinfo.patch_norm ...
          = Jinfo.bayes_parm.patch_norm;
    else
      load(curr_file,'bayes_parm');
      if exist('bayes_parm'), 
        % following line will be deleted after checking function: 
        % vbmeg_inst.plotcmap{inst_id}.bayes_parm = bayes_parm;
        vbmeg_inst.plotcmap{inst_id}.Jinfo.patch_norm = ...
            bayes_parm.patch_norm;
      else
        vbmeg_inst.plotcmap{inst_id}.Jinfo.patch_norm = false;
      end
    end
  end

  % The following code about current amplitude is the same with that in
  % job_plot_cmap_change_trial, and thus should be modified such as
  % invoking the function in some way to remove duplication of code. 
  % physical unit of current
  if vbmeg_inst.plotcmap{inst_id}.patch_norm, % [pAm/mm^2]
    vbmeg_inst.plotcmap{inst_id}.Jact ...
        = vbmeg_inst.plotcmap{inst_id}.Jact*1e6; % (=1e12*1e-6);
    vbmeg_inst.plotcmap{inst_id}.Jbck ...
        = vbmeg_inst.plotcmap{inst_id}.Jbck*1e6; % (=1e12*1e-6);
  else                          % [nAm]
    vbmeg_inst.plotcmap{inst_id}.Jact ...
        = vbmeg_inst.plotcmap{inst_id}.Jact*1e9;
    vbmeg_inst.plotcmap{inst_id}.Jbck ...
        = vbmeg_inst.plotcmap{inst_id}.Jbck*1e9;
  end

  % scale of current amplitude
  if size(vbmeg_inst.plotcmap{inst_id}.Jact,3) > 1
    ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
    Jmax = max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
    Jmin = min(min(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
  else
    Jmax = max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:))));
    Jmin = min(min(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:))));
  end
  vbmeg_inst.plotcmap{inst_id}.Jmax = Jmax;
  vbmeg_inst.plotcmap{inst_id}.Jmin = Jmin;
  vbmeg_inst.plotcmap{inst_id}.Jmax_plot = Jmax;
  vbmeg_inst.plotcmap{inst_id}.Jmin_plot = Jmax*0.1;
  
  % clear string in textbox for time-frequency data
  set(vbmeg_inst.plotcmap{inst_id}.ed10,'String','');
end

% load cortical area data
update_flag = vb_table_query_update_flag(props_out,'area_file');

if update_flag,
  area_file = vb_table_query_value(props_out,'area_file');
else
  area_file = '';
end

if ~isempty(area_file),
  vbmeg_inst.plotcmap{inst_id}.area_file = area_file;
  
  % update listbox
  keyset = vb_get_keyset_area(area_file);
  set(vbmeg_inst.plotcmap{inst_id}.lb2,'String',keyset);
  set(vbmeg_inst.plotcmap{inst_id}.lb2,'Value',1);
  
  % Update cortical area
  job_plot_cmap_update_area(inst_id);
end

% load cortical activity data
update_flag = vb_table_query_update_flag(props_out,'act_file');

if update_flag, 
  act_file = vb_table_query_value(props_out,'act_file');
else
  act_file = '';
end

if ~isempty(act_file),
  % filename
  vbmeg_inst.plotcmap{inst_id}.act_file = act_file;
  
  % update listbox
  keyset = vb_get_keyset_act(act_file);
  set(vbmeg_inst.plotcmap{inst_id}.lb1,'String',keyset);
  set(vbmeg_inst.plotcmap{inst_id}.lb1,'Value',1);
  
  % update activity map
  job_plot_cmap_update_xxP(inst_id);
end

% change figure title/act_file/area_file edit box
if ~isempty(curr_file), 
  [tmp,fname,ext] = fileparts(curr_file);
  set(h_fig,'Name',['job_plot_currentmap: ' fname ext]);
%elseif ~isempty(tf_file), 
%  [tmp,fname,ext] = fileparts(curr_file);
%  set(h_fig,'Name',['job_plot_currentmap: ' fname ext]);
else
  set(h_fig,'Name',['job_plot_currentmap: ']);
end

% Update plots
job_plot_cmap_update_colorbarscale(inst_id);
job_plot_cmap_update_filterradius(inst_id);
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id,true);

return;