function J = job_plot_cmap_get_spatialpattern(inst_id)
% Get spatial pattern of data using current TOI and FOI. 
%
% When time-frequency data is loaded, it is spatially smoothed by
% gaussian filter, which is saved in time-frequency file.
%
% [syntax]
% J = job_plot_cmap_get_spatialpattern(inst_id)
%
% [history]
% 2010-12-11 taku-y
%  [new] This function is newly created.
% 2011-01-28 taku-y
%  [enhancement] Activity map plot supported. 
% 2011-02-28 taku-y
%  [debug] Time point index corrected.
% 2012-10-15 taku-y
%  [trivial] Modified debug messages.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
const = vb_define_verbose;
VERBOSE_LEVEL_DEBUG = const.VERBOSE_LEVEL_DEBUG;

% --- Global variables
Jinfo    = vbmeg_inst.plotcmap{inst_id}.Jinfo;
TFinfo   = vbmeg_inst.plotcmap{inst_id}.TFinfo;
toi      = vbmeg_inst.plotcmap{inst_id}.toi;
foi      = vbmeg_inst.plotcmap{inst_id}.foi;
cb7      = vbmeg_inst.plotcmap{inst_id}.cb7;
xxP      = vbmeg_inst.plotcmap{inst_id}.xxP;
%lb1      = vbmeg_inst.plotcmap{inst_id}.lb1;
%act_file = vbmeg_inst.plotcmap{inst_id}.act_file;

% debug messages
vb_disp('job_plot_cmap_get_spatialpattern','DEBUG');
vb_disp(sprintf('size(toi) = %d, %d',size(toi)),'DEBUG');
vb_disp(sprintf('size(foi) = %d, %d',size(foi)),'DEBUG');

% --- Calculate spatial pattern
I = size(vbmeg_inst.plotcmap{inst_id}.V,1);
J = zeros(I,1);

if ~isempty(xxP) && get(cb7,'Value'),
  J = xxP;
elseif ~isempty(Jinfo), 
  if vb_version_cmp(Jinfo.version,'>=','0.9-0.a.0'), 
    [tmp,ix(1)] = min(abs(Jinfo.Tmsec-toi(1)));
    [tmp,ix(2)] = min(abs(Jinfo.Tmsec-toi(2)));
    if ix(1)>ix(2),
      tt = ix(2):ix(1);
    else
      tt = ix(1):ix(2);
    end
  else
    Tstart = vbmeg_inst.plotcmap{inst_id}.Tstart;
    tt = ceil((toi(1):toi(2))*Jinfo.SampleFreq/1000-Tstart ...
              +Jinfo.Pretrigger)+1;
  end
  
  % Debug code
  %if vb_get_verbose==VERBOSE_LEVEL_DEBUG, 
  %  size(J)
  %  size(Jinfo.ix_act)
  %  max(Jinfo.ix_act)
  %  disp('pause');
  %  pause;
  %end

  % Mean of current over time window
  ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
  if size(vbmeg_inst.plotcmap{inst_id}.Jact,3) > 1
    J(Jinfo.ix_act_ex,:) ...
        = mean(vbmeg_inst.plotcmap{inst_id}.Jact(:,tt,ix_trial),2);
  else
    J(Jinfo.ix_act_ex,:) ...
        = mean(vbmeg_inst.plotcmap{inst_id}.Jact(:,tt),2);
  end
elseif ~isempty(TFinfo), 
  [tmp,ix(1)] = min(abs(TFinfo.Tmsec-toi(1)));
  [tmp,ix(2)] = min(abs(TFinfo.Tmsec-toi(2)));
  if ix(1)>ix(2),
    tt = ix(2):ix(1);
  else
    tt = ix(1):ix(2);
  end
  
  % Frequency window
  [tmp,ix(1)] = min(abs(TFinfo.freq-foi(1)));
  [tmp,ix(2)] = min(abs(TFinfo.freq-foi(2)));
  if ix(1)>ix(2), 
    ff = ix(2):ix(1);
  else
    ff = ix(1):ix(2);
  end
  
  % debug messages
  vb_disp(sprintf('min and max of tt = %d, %d\n',min(tt),max(tt)), 'DEBUG');
  vb_disp(sprintf('min and max of ff = %d, %d\n',min(ff),max(ff)), 'DEBUG');
  
  % Mean of data over time-frequency window
  tmp = sum(sum(vbmeg_inst.plotcmap{inst_id}.data(ff,tt,:),1),2);
  tmp = reshape(tmp,[length(tmp) 1])./(length(ff)*length(tt));
  J(TFinfo.ix_act_ex) = TFinfo.Wact*tmp;
  
  % Debug code
  %if vb_get_verbose==VERBOSE_LEVEL_DEBUG, 
  %  figure;
  %  subplot(2,1,1);
  %  plot(sum(TFinfo.Wact,1));
  %  subplot(2,1,2);
  %  plot(sum(TFinfo.Wact,2));
  %  disp('pause');
  %  pause;
  %  close;
  %end
else
  J = [];
end

return;
