function job_plot_cmap_change_trial(inst_id)
% Callback function invoked when trial number changes. 
%
% [syntax]
% job_plot_cmap_change_trial(inst_id);
%
% [input]
% inst_id: instance id of job_plot_currentmap gui.
%
% [history]
% ????-??-?? Taku Yoshioka
% 2010-03-08 rhayashi
%  Read single trial data at a one time when multiple trial current data
%  is inputted
% 2010-12-09 taku-y
%  [minor change] If plotcmap.currfile is empty, nothing is done. 
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced with "ix_trial"
% 2012-02-17 taku-y
%  [debug] Inward current as positive. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

object = vbmeg_inst.plotcmap{inst_id};
max_trial = 0;

if isempty(object.curr_file), 
  return;
end

h_fig = vbmeg_inst.plotcmap{inst_id}.h_fig;
if exist(object.curr_file, 'file') == 2
    set(h_fig,'Pointer','watch');
    drawnow;
    Jinfo = vb_load_current_info(object.curr_file);
    if isfield(Jinfo, 'Ntrial')
        max_trial = Jinfo.Ntrial;
    elseif ~isempty(object.Jact)
        max_trial = size(object.Jact, 3);
    end
else
    return;
end

% get trial index from GUI
ix_trial = str2num(get(vbmeg_inst.plotcmap{inst_id}.ed1, 'String'));
%if isempty(ix_trial)
  %vb_disp(['Trial index must be an integer value. Forced ix_trial to ' ...
  %         'be 1 (in job_plot_cmap_load_data.m). '], 'WARNING');
  %ix_trial = 1;
%end
ix_trial = ceil(ix_trial);

% check trial index valid
if isempty(ix_trial) | ix_trial > max_trial | ix_trial<1, 
  errordlg('Trial index is invalid.','Warning','modal');
  ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
  set(vbmeg_inst.plotcmap{inst_id}.ed1,'String', num2str(ix_trial));
  set(h_fig,'Pointer', 'arrow');
  return;
end

% update trial index on GUI
set(vbmeg_inst.plotcmap{inst_id}.ed1, 'String', num2str(ix_trial));
ave_mode = vbmeg_inst.plotcmap{inst_id}.ave_mode;

% update trial index in global variable
vbmeg_inst.plotcmap{inst_id}.ix_trial = ix_trial;

if size(vbmeg_inst.plotcmap{inst_id}.Jact, 3) > 1
  ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
  vbmeg_inst.plotcmap{inst_id}.Jmax = ...
    max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
else
  [Jinfo, Jact] = vb_load_current(object.curr_file, 0, ave_mode, ix_trial);
  vbmeg_inst.plotcmap{inst_id}.Jact ...
      = -1*Jact; % inward current as positive
  vbmeg_inst.plotcmap{inst_id}.ix_trial = ix_trial;
  
  % physical unit of current
  if vbmeg_inst.plotcmap{inst_id}.patch_norm, % [pAm/mm^2]
    vbmeg_inst.plotcmap{inst_id}.Jact ...
        = vbmeg_inst.plotcmap{inst_id}.Jact*1e6; % (=1e12*1e-6);
    vbmeg_inst.plotcmap{inst_id}.Jbck ...
        = vbmeg_inst.plotcmap{inst_id}.Jbck*1e6; % (=1e12*1e-6);
  else                          % [nAm]
    vbmeg_inst.plotcmap{inst_id}.Jact ...
        = vbmeg_inst.plotcmap{inst_id}.Jact*1e9;
    vbmeg_inst.plotcmap{inst_id}.Jbck ...
        = vbmeg_inst.plotcmap{inst_id}.Jbck*1e9;
  end

  % scale of current amplitude
  if size(vbmeg_inst.plotcmap{inst_id}.Jact,3) > 1
    ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
    Jmax = max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
    Jmin = min(min(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
  else
    Jmax = max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:))));
    Jmin = min(min(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:))));
  end
  
  vbmeg_inst.plotcmap{inst_id}.Jmax = Jmax;
  vbmeg_inst.plotcmap{inst_id}.Jmin = Jmin;
  vbmeg_inst.plotcmap{inst_id}.Jmax_plot = Jmax;
  vbmeg_inst.plotcmap{inst_id}.Jmin_plot = Jmax*0.1;
end

job_plot_cmap_update_timecourse(inst_id);
job_plot_cmap_update_spatialpattern(inst_id);

set(h_fig,'Pointer', 'arrow');
return;