function job_edit_act_update_talcoord(inst_id)
% Update standard brain coordinate
%
% --- History
% 2009-05-22 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix = vbmeg_inst.editact{inst_id}.ix;
rb1 = vbmeg_inst.editact{inst_id}.rb1;
rb2 = vbmeg_inst.editact{inst_id}.rb2;
ed4 = vbmeg_inst.editact{inst_id}.ed4;
ed5 = vbmeg_inst.editact{inst_id}.ed5;

%
% Update standard brain coordinate
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(vbmeg_inst.editact{inst_id}.ed5,'String',num2str(ix)); 

if get(rb1,'Value')==get(rb1,'Max'), 
  Vstd = vbmeg_inst.editact{inst_id}.Vtal;
else
  Vstd = vbmeg_inst.editact{inst_id}.Vmni;
end

str = ['[' num2str(ceil(Vstd(ix,1))) ',' ...
       num2str(ceil(Vstd(ix,2))) ',' ...
       num2str(ceil(Vstd(ix,3))) ']'];
set(vbmeg_inst.editact{inst_id}.ed4,'String',str);
