function job_edit_act_update_spatialpattern(inst_id)
% Update spatial pattern
%
% --- Syntax
% job_edit_act_update_spatialpattern(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
% 2009-05-22 Taku Yoshioka
%  Modify display of standard brain coordinates
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.editact{inst_id}.h_fig; 
h_space = vbmeg_inst.editact{inst_id}.h_space;
h_cbar = vbmeg_inst.editact{inst_id}.h_cbar;
V = vbmeg_inst.editact{inst_id}.V;
F = vbmeg_inst.editact{inst_id}.F;
plot_parm = vbmeg_inst.editact{inst_id}.plot_parm;
ix = vbmeg_inst.editact{inst_id}.ix;
ed4 = vbmeg_inst.editact{inst_id}.ed4;
ed6 = vbmeg_inst.editact{inst_id}.ed6;
cb1 = vbmeg_inst.editact{inst_id}.cb1;
cb2 = vbmeg_inst.editact{inst_id}.cb2;
Vtal = vbmeg_inst.editact{inst_id}.Vtal;
model_type_fold_rb = vbmeg_inst.editact{inst_id}.model_type_fold_rb;
model_type_inflate_rb = ...
    vbmeg_inst.editact{inst_id}.model_type_inflate_rb;
xxP = vbmeg_inst.editact{inst_id}.xxP;
if ~isempty(xxP), xxP = xxP{1}; end

%
% Preparation for cortical surface plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'Pointer','arrow');
drawnow;

% Original/Inflated model
if get(model_type_fold_rb,'Value')==1,  
  V = vbmeg_inst.editact{inst_id}.V;
  inf_C = [];
else
  V = vbmeg_inst.editact{inst_id}.Vinf;
  inf_C = vbmeg_inst.editact{inst_id}.inf_C;
end

% Get display parameters
LRflag = [];
if get(cb1,'Value')==get(cb1,'Max'), LRflag = 'L'; end
if get(cb2,'Value')==get(cb2,'Max'), LRflag = [LRflag 'R']; end
plot_parm.LRflag = LRflag;

if isempty(xxP), isact = 0; else isact = 1; end
plot_parm.isact = isact;

%
% Plot brain activities superimposed on the cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'CurrentAxes',h_space);
cla; 
job_edit_act_plotbrain(plot_parm,V,F,inf_C,xxP,min(xxP),max(xxP));
v = caxis;
set(ed6,'String',['[' num2str(v) ']']);
axis tight;
axis equal;
set(h_space,'Box','on','XTick',[],'YTick',[],'ZTick',[]);
reset(h_cbar);
colorbar(h_cbar);

% Add drag/zoom function
vb_dragzoom(h_space, '3d');
patches = get(h_space, 'Children');
set(patches, 'ButtonDownFcn', {@inner_send_select_vertex, inst_id});

% get view angle
[a, e] = view(h_space);

% set this value to get MATLAB to regcognize that the axes is 3D graphics.
% (if not set, zoom function behave strange.)
if a == 0 && e == 90
    view(h_space, [0, 89]);
end

% Selected vertex
if ix~=0, 
  hold on;
  h = plot3(V(ix,1),V(ix,2),V(ix,3),'gx');
  set(h,'MarkerSize',plot_parm.ms,'EraseMode','xor',...
	'LineWidth',plot_parm.lw);

  % Update talairach coordinates
  job_edit_act_update_talcoord(inst_id);
  %str = ['(' num2str(ceil(Vtal(ix,1))) ',' ...
  %       num2str(ceil(Vtal(ix,2))) ',' ...
  %       num2str(ceil(Vtal(ix,3))) ')'];
  %set(ed4,'String',str);
end


function inner_send_select_vertex(src, evt, inst_id)
global vbmeg_inst;
fig = vbmeg_inst.editact{inst_id}.h_fig;
% double click
if strcmpi(get(fig, 'SelectionType'), 'open')
    job_edit_act_select_vertex(inst_id);
end
