function project_mgr_view_update_builders(fig)
% update builder name list
% [USAGE]
%    project_mgr_view_update_builders(<fig>);
% [IN]
%    fig : figure handle of project_mgr
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

component = [H.add_parm_to_builder_push;
             H.add_builder_push;
             H.copy_builder_push;
             H.remove_builder_push;
             H.open_builder_push;
             H.builder_popup];

%
% --- Add builder names to popup listbox
%
builders = cell(0);
Nbuilders = length(data.batch_builders);
for k=1:Nbuilders
    bmgr = data.batch_builders{k};
    name = vb_batch_mgr_get_name(bmgr);
    builders{k,1} = name;
end

% adjust focus line
no_line = get(H.builder_popup, 'Value');
if no_line < 1
    no_line = 1;
elseif no_line > Nbuilders
    no_line = Nbuilders;
end
% Component enable/disable
if Nbuilders == 0
    set(component, 'Enable', 'off');
else
    set(component, 'Enable', 'on');
    set(H.builder_popup, 'String', builders);
    set(H.builder_popup, 'Value',  no_line);
end
