function project_mgr_uimenu_tool_callback(fig, hObj)
% callback function for uimenu 'Tools'.
% [USAGE]
%    project_mgr_uimenu_tool_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of project_mgr gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('hObj', 'var') || isempty(hObj)
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles
proj_root = project_file_mgr('get_project_root');

switch(hObj)
    case H.tool_convert_dicom_nifti
        [RAS] = convert_dicom_nifti;
        if ~isempty(RAS)
            str = cell(2,1);
            str{1} = 'RAS NIfTI files is created.';
            str{2} = [RAS];
            msgbox(str, 'DICOM converter');
        end
        fig_t = -1;
    case H.tool_brain_file_maker
        obj = brain_file_maker_new(proj_root);
        fig_t = brain_file_maker_get_figure_handle(obj);
    case H.tool_job_view_cortex
        fig_t = tool_launcher('init', 1);
    case H.tool_job_select_area
        fig_t = tool_launcher('init', 2);
    case H.tool_job_edit_area
        fig_t = tool_launcher('init', 3);
    case H.tool_job_plot_meg
        fig_t = tool_launcher('init', 4);
    case H.tool_job_plot_currentmap
        job_plot_currentmap;
        fig_t = -1;
%        fig_t = tool_launcher('init', 5);
    case H.tool_job_edit_act
        fig_t = tool_launcher('init', 6);
    case H.tool_trial_extractor
        fig_t = tool_launcher('init', 7);
    case H.tool_signal_processor
        fig_t = tool_launcher('init', 8);
    case H.tool_view_head_2d
        fig_t = tool_launcher('init', 9);
end

data.tools_fig = [data.tools_fig; fig_t];

% save data
guidata(fig, data);
