function project_mgr_uimenu_module_callback(fig, hObj)
% callback function for uimenu 'module'.
% [USAGE]
%    project_mgr_uimenu_module_callback(fig, hObj);
% [IN]
%     fig : figure handle of project_mgr gui.
%    hObj : event component handle
% [OUT]
%   none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('fig', 'var') || isempty(hObj)
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

switch(hObj)
    case H.uimenu_module_brain
        project_mgr_launch_module(fig, 'brain');
    case H.uimenu_module_fmri
        project_mgr_launch_module(fig, 'fmri');
    case H.uimenu_module_biosemi_eeg
        project_mgr_launch_module(fig, 'biosemi_eeg');
    case H.uimenu_module_brainamp_eeg
        project_mgr_launch_module(fig, 'brainamp_eeg');
%     case H.uimenu_module_sbi_meg
%         project_mgr_launch_module(fig, 'sbi_meg');
    case H.uimenu_module_yokogawa_meg
        project_mgr_launch_module(fig, 'yokogawa_meg');
    case H.uimenu_module_leadfield
        project_mgr_launch_module(fig, 'leadfield');
    case H.uimenu_module_bayes
        project_mgr_launch_module(fig, 'bayes');
    case H.uimenu_module_current
        project_mgr_launch_module(fig, 'current');
    case H.uimenu_module_spm_curry_head
        project_mgr_launch_module(fig, 'spm_curry_head');
end

