function data = project_mgr_load_project_file(project_file, data, fig)
% load project file.
% [USAGE]
%    data = project_mgr_load_project_file(<project_file>, <data>, <fig>);
% [IN]
%    project_file : project file name(.prj.mat).
%            data : data structure of project_mgr.
%             fig : figure handle of project_mgr.
% [OUT]
%    data : updated data structure of project_mgr.

%
% --- Previous check
%
if ~exist('project_file', 'var')
    error('project_file is a required parameter.');
end
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if exist(project_file, 'file') ~= 2
    return;
end

%
% --- Main Procedure
%

% load batch builders
if ~isempty(whos('-file', project_file, 'batch_builders'))
    b = load(project_file, 'batch_builders');
    data.batch_builders = b.batch_builders;
else
    data.batch_builders = cell(0);
    data.batch_builders{1} = vb_batch_mgr_new('batch builder1');
end

% Load project
data.project_file = project_file;
guidata(fig, data);
% load history
err = project_file_mgr('load', project_file);
if ~err
    set_project_filename(project_file);
    if ishandle(data.batch_fig)
        delete(data.batch_fig);
        data.batch_fig = -1;
        guidata(fig, data);
    end
end
project_mgr_view_update(fig);


% Save last loaded project_file
uname = vb_get_username;
uname = strrep(uname, ' ', ''); % remove white space

save_dir = [tempdir, 'vbmeg-', uname];

if exist(save_dir, 'dir') ~= 7
    vb_mkdir(save_dir);
end

if exist(save_dir, 'dir') ~= 7
    return;
end

fname = [save_dir, '/project_file_loaded.mat'];
vb_save(fname, 'project_file');
