function project_mgr_gui_reset(fig)
% reset project_mgr gui.
% [USAGE]
%    project_mgr_gui_reset(<fig>);
% [IN]
%    fig : figure handle of project_mgr gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

% project information reset
set(H.project_name_edit, 'String', '');
set(H.project_root_edit, 'String', '');

% check model parameter reset
set(H.brain_parm_edit, 'String', '');
set(H.fmri_parm_edit, 'String', '');
set(H.meg_parm_edit, 'String', '');
project_mgr_init_ix_for_check_model(fig);

% parameter reset
set(H.parameter_display_edit, 'String', '');

% history listbox reset
set(H.history_listbox, 'String', '');
set(H.history_listbox, 'Value', 1);
