function create_new_project_callback(fig, hObj)
% callback function for create_new_project gui.
% [USAGE]
%    create_new_project_callback(fig);
% [IN]
%     fig : create_new_figure gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('fig is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see create_new_project)
data = guidata(fig);
H = data.H; % component handles

switch(hObj)
    case H.project_root_push
        directory = dir_dialog(get(H.project_root_edit, 'String'));
        if directory ~= 0
            set(H.project_root_edit, 'String', directory);
            if ~isempty(get(H.project_name_edit, 'String'))
                set(H.OK_push, 'Enable', 'on');
            end
        end
    case H.OK_push
        [H, err, project_filename] = make_project(H);
        data.err = err;
        data.cancelled = false;
        data.project_filename = project_filename;
        set(fig, 'Visible', 'off');
    case {H.CANCEL_push, H.figure}
        data.cancelled = true;
        data.err = false;
        data.project_filename = [];
        set(fig, 'Visible', 'off');
end

% save data
guidata(fig, data);

%
% --- Inner function
%
function [H, err, project_file] = make_project(H)
% This function asks project_file_mgr to make a new project file.
%
% [IN]
%    H : gui component handles
% [OUT]
%    H   : gui component handles
%    err : true(failed to make project file) or false.
%    project_file : project file name
%
   proj_root = get(H.project_root_edit, 'String');
   project_name = get(H.project_name_edit, 'String');

   name = strrep(project_name, ' ', '_');
   name = strrep(name, '/', '_');
   name = strrep(name, '\', '_');

   project_file = [proj_root filesep name, '.prj.mat'];
   err = false;
   
   write_file = false;
   
   % parameter check
   if isempty(proj_root)
       msgbox('project_root does not selected.', 'notice');
       err = true;
       return;
   end
   
   if isempty(project_name)
       msgbox('project_name is empty.', 'notice');
       err = true;
       return;
   end
   
   % confirm file make?
   dlg_str = ['Create new project? (project_name : ' project_name ')'];
   button = questdlg(dlg_str,...
                   'create project',...
                   'Yes', 'No',... % choice button type
                   'Yes');          % default choice
   if strcmp(button, 'Yes')
       % file already exist?
       if exist(project_file, 'file')
           % overwrite yes
           button = questdlg('project file already exists, overwrite?',...
                           'confirm',...
                           'Yes', 'No', ...
                           'No');
           if strcmp(button, 'Yes')
               delete(project_file);
               write_file = true;
           else
               H.cancelled = true;
           end
       else
           % new file create
           write_file = true;
       end
   end

   % create project file
   if write_file
       err = project_file_mgr('make', project_file, project_name, proj_root);
       if err
           msgbox('project file create failed.', 'notice');
       else
           H.project_filename = project_file;
           msgbox('project file is created.', 'notice');
       end
   end
