function pa_yokogawa_meg_set_parm(fig, yokogawa_meg_parm)
% sets meg parameters to yokogawa meg gui.
% [USAGE]
%    pa_yokogawa_meg_set_parm(<fig>, [,yokogawa_meg_parm]);
% [IN]
%                  fig : figure handle of yokogawa meg gui.
%    yokogawa_meg_parm : to be set meg_parm[default:vb_set_yokogawa_meg_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

if isempty(yokogawa_meg_parm)
    % default value
    yokogawa_meg_parm = vb_set_yokogawa_meg_parm;
end

%
% --- Main Procedure
%

% load data(@see pa_yokogawa_meg_create)
data = guidata(fig);
H = data.H; % component handles

% data file
set(H.meg_file_edit, 'String', yokogawa_meg_parm.yokogawa_file);

% position file
set(H.position_file_edit, 'String', yokogawa_meg_parm.pos_file);

% Ext gain
if isempty(yokogawa_meg_parm.ex_ch_gain)
    set(H.gain_setting_text, 'String', 'None');
else
    set(H.gain_setting_text, 'String', 'Specified');
end

% save dir
%[save_dir] = fileparts(yokogawa_meg_parm.meg_file);
[save_dir] = vb_get_file_parts(yokogawa_meg_parm.meg_file);
set(H.save_dir_edit, 'String', save_dir);

% binary dir
%set(H.binary_dir_edit, 'String', yokogawa_meg_parm.saveman.data_dir);

% MEG-MAT file(output)
set(H.megmat_file_edit, 'String', yokogawa_meg_parm.meg_file);

% save data
data.yokogawa_meg_parm = yokogawa_meg_parm;
guidata(fig, data);

% view update
pa_yokogawa_meg_util(fig, 'update_output_fname');
pa_yokogawa_meg_util(fig, 'update_exec_push_status');
