function [dirname, fnames, canceled] = pa_prjfile_select(proj_root, ext, caption)
% file select dialog 
%  - The file is in under the project directory
%
% [IN]  proj_root : Top of the selectable directory.
%       ext{n}    : file extension (ex. '.img', '.txt')
%         caption : dialog title(string)                  [string]
% [OUT] dirname   : relative directory name from proj_root
%       fnames{n} : selected filenames.
%       canceled  : true/false (true means dialog closed by cancel)
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
persistent h;       % for singleton check
persistent HISTORY; % file choice history

dirname = [];
fnames= [];
canceled = false;

% dialog can open 1 at a same time.
if ~isempty(h)
    canceled = true;
    return;
end  

h = file_dialog;
h = set(h, 'file_extensions', ext);
if exist('caption', 'var')
    h.dialog_title = caption;
end
h = set(h, 'current_dir', proj_root);

% ǥ쥯ȥɲ
hist_num = size(HISTORY, 2);
if ~isempty(HISTORY)
    ix = [];
    k=1;
    for k=1:hist_num
         for j=1:size(ext,2)
            if ~isempty(strmatch(ext{j}, HISTORY{k}{2}, 'exact'))
                ix = [ix;k];
            end
            h = set(h, 'hist_dir', {HISTORY{k}{1}});
        end
    end
    if ~isempty(ix)
       current_dir = HISTORY{ix(end)}{1};
    else
       current_dir = HISTORY{k}{1};
    end
    h = set(h, 'current_dir', char(current_dir));
end
[dirname fnames] = visible(h);

% CANCELɤȽ
if isempty(dirname)
    canceled = true;
end

% save history
if ~isempty(dirname)
    HISTORY{hist_num+1} = {dirname, ext};
end

% ѥproj_rootХѥˤ
if ~isempty(dirname) & ~isempty(proj_root)
    dirname = vb_relativepath(dirname, proj_root);
    dirname = dirname(1:length(dirname)-1);
end

h = [];
