function [obj] = vb_timeseries_viewer_callback(obj, hObj)
% Callback function for timeseries viewer
% [Usage]
%    [obj] = vb_timeseries_viewer_callback(obj, H);
% [Input]
%     obj : vb_timeseries_viewer object
%    hObj : handle of action component.
% [Output]
%     obj : vb_timeseries_viewer object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
get(hObj, 'Tag'); % debug

obj.event_number = obj.event_number + 1;

H   = obj.H;

Nsample = obj.Nsample;
freq    = obj.freq;

switch(hObj)
    case H.timeseries_slider
        obj = vb_timeseries_viewer_update_display_time_range(obj);
    case H.timepoint_current_text
        obj = vb_timeseries_viewer_specify_display_time(obj);
    case H.Yscale_slider
        % Get slider position
        val = 1-get(hObj, 'Value');
        window_len = val * 100;
        if window_len >= obj.total_time_sec
            window_len = obj.total_time_sec;
        end
        obj.window_len = window_len;
        % update range
        obj = vb_timeseries_viewer_specify_display_time(obj);
    case H.make_preview_file_push

        h = msgbox('Now creating preview file....', 'Please wait');
        bh = findall(h, 'Style', 'pushbutton');
        set(bh, 'Visible', 'off'); drawnow; pause(0.1);
        % Get measurement type('MEG' or 'EEG')
        MEGinfo = vb_continuous_file_get_meg_info(obj.org_file);
        measurement = vb_info_get_measurement(MEGinfo);

        % Set preview file to view measurement data
        if strcmpi(measurement, 'MEG')
            ext = '.meg.mat';
            func_name = 'vb_megfile_filter_ch_data';
        elseif strcmpi(measurement, 'EEG')
            ext = '.eeg.mat';
            func_name = 'vb_eegfile_filter_ch_data';
        end
        
        org_file = vb_continuous_file_get_filename(obj.org_file);
        [base_path, base_filename] = vb_get_file_parts(strrep(org_file, ext, ''));

        preview_file = fullfile(base_path, [base_filename, '_50Hz', ext]);
        proc_spec.parm.fsamp = 50;
        try
            feval(func_name, org_file, proc_spec, preview_file);
        catch
            errordlg(...
              ['Failed to make preview file:  ' preview_file, ...
               sprintf(...
                '\nCheck directory permission.')], ...
              'Preview file');
        end
        if ishandle(h), delete(h); end

        if exist(preview_file, 'file') == 2
            obj.preview_file = vb_continuous_file_new(preview_file, obj.data_ch_list);
            obj = vb_timeseries_viewer_plot_measurement_data(obj);
            % update display time range
            obj = vb_timeseries_viewer_update_display_time_range(obj);
        end
    case {H.ylimit_high_edit, H.ylimit_low_edit}
        if isnan(str2double(get(hObj, 'String')))
            errordlg('Invalid value was specified(Not a number). please input again.', 'Range');
            set(hObj, 'String', '');
            return;
        end
        high = str2double(get(H.ylimit_high_edit, 'String'));
        low  = str2double(get(H.ylimit_low_edit, 'String'));
        if ~isnan(high) && ~isnan(low)
            ylim(H.data_axes, [low, high]);
            range = ylim(H.data_axes);
            Ydata = [range(1), range(2)];
            for k=1:length(obj.trial_onset_handles)
                set(obj.trial_onset_handles(k), 'Ydata', Ydata);
            end
        end
    case H.data_channel_push
        [selected_ch_list, cancel] = ...
        vb_te_channel_selector_new(obj.data_ch_list, ...
                                   obj.data_ch_list(obj.data_ch_list_plot_ix));
        if ~cancel
            obj.data_ch_list_plot_ix = [];
            for k=1:length(selected_ch_list)
                ix = strmatch(selected_ch_list{k}, obj.data_ch_list, 'exact');
                obj.data_ch_list_plot_ix = [obj.data_ch_list_plot_ix; ix];
            end
            obj = vb_timeseries_viewer_update_display_time_range(obj);
        end
    case H.trigger_channel_push
        [selected_ch_list, cancel] = ...
        vb_te_channel_selector_new(obj.trig_ch_list, ...
                                   obj.trig_ch_list(obj.trig_ch_list_plot_ix));
        if ~cancel
            obj.trig_ch_list_plot_ix = [];
            for k=1:length(selected_ch_list)
                ix = strmatch(selected_ch_list{k}, obj.trig_ch_list);
                obj.trig_ch_list_plot_ix = [obj.trig_ch_list_plot_ix; ix];
            end
            obj = vb_timeseries_viewer_update_display_time_range(obj);
        end
    case {H.ylimit_trigger_high_edit, H.ylimit_trigger_low_edit}
        if isnan(str2double(get(hObj, 'String')))
            errordlg('Invalid value was specified(Not a number). please input again.', 'Range');
            set(hObj, 'String', '');
            return;
        end
        high = str2double(get(H.ylimit_trigger_high_edit, 'String'));
        low  = str2double(get(H.ylimit_trigger_low_edit, 'String'));
        ylim(H.trigger_axes, [low, high]);
        if ~isnan(high) && ~isnan(low)
            range = ylim(H.trigger_axes);
            Ydata = [range(1), range(2)];
            for k=1:length(obj.ext_onset_handles)
                set(obj.ext_onset_handles(k), 'Ydata', Ydata);
            end
        end
    case {H.scale_minus_push, H.scale_plus_push}
        val  = get(H.Yscale_slider, 'Value');
        step = get(H.Yscale_slider, 'SliderStep');
        max_val = get(H.Yscale_slider, 'Max');
        min_val = get(H.Yscale_slider, 'Min');
        if hObj == H.scale_minus_push
            val = val - step(1);
            if val < min_val, val = min_val; end
        else
            val = val + step(1);
            if val > max_val, val = max_val; end
        end
        set(H.Yscale_slider, 'Value', val);

        % update range
        obj = vb_timeseries_viewer_callback(obj, H.Yscale_slider);
    case H.trigger_yrange_fix_check
        if get(hObj, 'Value')
            % Fix y range
            high = str2double(get(H.ylimit_trigger_high_edit, 'String'));
            low  = str2double(get(H.ylimit_trigger_low_edit, 'String'));
            % input current range to box
            if isnan(high) || isnan(low)
                range = ylim(H.trigger_axes);
                set(H.ylimit_trigger_low_edit, 'String', num2str(range(1)));
                set(H.ylimit_trigger_high_edit, 'String', num2str(range(2)));
            end
            set(H.trigger_axes, 'YLimMode', 'manual');
        else
            set(H.trigger_axes, 'YLimMode', 'auto');
        end
    case H.trigger_min_max_value_push
        parm.min_value = obj.trigger_min;
        parm.max_value = obj.trigger_max;
        vb_edit_struct(parm, 'min/max value of trigger data');
    case H.trigger_axes
        point = get(hObj, 'currentpoint');
        vb_text_area('Y value', num2str(point(1,2)));
    case H.save_trigger_file
        [f, p] = uiputfile({'*.trig.mat'}, 'Save trigger As', obj.trigger_file);
        if isequal(f, 0) || isequal(p, 0)
            % cancel
        else
            save_file = fullfile(p, f);
            vb_timeseries_viewer_save_trigger_file(obj, save_file);
            msgbox(['Saved:' save_file], 'notice');
        end
    case H.load_trigger_file
        [f, p] = uigetfile({'*.trig.mat'}, 'Load trigger file', obj.trigger_file);
        if isequal(f, 0)
            % cancel
        else
            load_file = fullfile(p, f);
            [trial_list, trig_ch_list] = ...
              vb_timeseries_viewer_load_trigger_file(obj.trigger_obj, load_file);
            if ~isempty(trial_list) && ~isempty(trig_ch_list)
                obj = vb_timeseries_viewer_set_trial(obj, trial_list);
                obj.trig_ch_list = trig_ch_list;
                % update display time range
                obj = vb_timeseries_viewer_update_display_time_range(obj); 
                msgbox('Triggers are loaded.', 'notice');
            end
        end
    otherwise
        if strcmp(get(hObj, 'Tag'), 'ext_trig_line')
            % clicked point
            point = get(H.trigger_axes, 'currentpoint');
            h = vb_text_area('Y value', num2str(point(1,2)));
        end

end

% not to crash when figure is closed while running plotting.
if ~ishandle(obj.figure), return; end

pre = guidata(obj.figure);
if pre.event_number < obj.event_number
    guidata(obj.figure, obj);
else
    obj = pre;
end
