function [tag_obj] = vb_tag_add_trial_index(tag_obj, ix)
% Add trial index to tag object.
% [USAGE]
%    [tag_obj] = vb_tag_add_trial_index(tag_obj, ix);
% [IN]
%    ix : index of trial data(which is stored in vb_trial_extractor object) [Nx1]
% [OUT]
%   tag_obj : updated tag object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tag_obj', 'var')
    error('tag_obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end

if size(ix, 2) ~= 1
    error('The shape of index should be [Nx1]');
end


%
% --- Main Procedure
%
tag_obj.trial_ix = [tag_obj.trial_ix; ix];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive tag_obj.');
end
