function [obj] = vb_continuous_file_new(file, read_ch_list)
% continuous file data.
% [USAGE]
%    obj = continous_file_new(file);
% [IN]
%              file : continous MEG/EEG-MAT file.
%      read_ch_list : <<optional>> if this list is specified,
%                     continous_file_get_sample() only returns these
%                     channels.
% [OUT]
%     obj : continous_file object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('file', 'var')
    error('file is a required parameter.');
end
if exist(file, 'file') ~= 2
    error('Specified continous file doesn''t exist.');
end
if ~exist('read_ch_list', 'var')
    read_ch_list = ''; % means read all channel
end

%
% --- Main Procedure
%

% Check continous data or not
MEGinfo = vb_load_meg_info(file);
if MEGinfo.Nrepeat ~= 1
    error('Specfied file is not a continuous MEG/EEG file.');
end

%
% --- Main Procedure
%
obj = struct;
obj.filename = file;
obj.MEGinfo  = MEGinfo;
obj.read_ch_list = read_ch_list;

%
% --- After check
%
if nargout < 1
    error('continuous_file object should be received.');
end
