function [pretrigger_len] = vb_continuous_file_get_pretrigger(obj)
% return pretrigger length(sample)
% [USAGE]
%    [pretrigger_len] = vb_continuous_file_get_pretrigger(obj);
% [IN]
%    obj : continuous_file object.
% [OUT]
%    pretrigger_len : pretrigger length(sample)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%
pretrigger_len = meginfo_get_pre_trigger(obj.MEGinfo);
if isempty(pretrigger_len)
    pretrigger_len = 0;
end
