function [data] = vb_trial_extractor_update_screen(data)
% GUI update
%
% [USAGE]
%    data = vb_trial_extractor_update_screen(data);
%
% [IN]
%    data : The application data.
% [OUT]
%    data : The updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H    = data.H;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Update file parameter
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(data.continuous_file)
    set(H.continuous_file_edit, 'String', vb_continuous_file_get_filename(data.continuous_file));
    ch_list = vb_continuous_file_get_ch_list(data.continuous_file, 'EXTRA');
    set(H.trigger_channel_listbox, 'String', sort(ch_list));
    freq = vb_continuous_file_get_sample_freq(data.continuous_file);
    set(H.sample_freq_text, 'String', num2str(freq));

    selected = get(H.trigger_channel_listbox, 'Value');
    if length(ch_list) < selected
        set(H.trigger_channel_listbox, 'Value', 1);
    end
else
    set(H.sample_freq_text, 'String', '');
    set(H.trigger_channel_listbox, 'String', '');
end

% Trial Length
trial_setting = data.trial_setting;
pretrigger_ms  = trial_setting.pretrigger_ms;
posttrigger_ms = trial_setting.posttrigger_ms;
minimum_distance_ms = trial_setting.minimum_distance_ms;

if pretrigger_ms
    set(H.pretrigger_length_edit, 'String', num2str(pretrigger_ms));
else
    set(H.pretrigger_length_edit, 'String', '');
end
if posttrigger_ms
    set(H.posttrigger_length_edit, 'String', num2str(posttrigger_ms));
else
    set(H.posttrigger_length_edit, 'String', '');
end
if minimum_distance_ms >= 0
    set(H.minimum_distance_edit, 'String', num2str(minimum_distance_ms));
else
    set(H.minimum_distance_edit, 'String', '');
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Update Trigger list
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Selected trigger type
type_selected = get(H.trigger_type_popup, 'Value');
type_items    = get(H.trigger_type_popup, 'String');
trig_type = type_items{type_selected};

% Trigger channel
ch_name_list    = get(H.trigger_channel_listbox, 'String');
selected_row    = length(get(H.trigger_channel_listbox, 'Value'));
if isempty(ch_name_list) || ...
   selected_row == 0
    set(H.trigger_add_push, 'Enable', 'off');
    set(H.trigger_view_push, 'Enable', 'off');
else
    set(H.trigger_add_push, 'Enable', 'on');
    set(H.trigger_view_push, 'Enable', 'on');
    if selected_row >= 2 && ~strcmp(trig_type, 'multi channel pattern')
        set(H.trigger_add_push, 'Enable', 'off');
    end
end

% Default off
set([H.analog_level_edit, H.integer_level_edit, ...
     H.bit_level_edit, H.trigger_level_text, ...
     H.flag_pattern_push], ...
     'Visible', 'off');
set([H.optional_parm_push, H.advanced_parm_push], 'Enable', 'off');
switch(trig_type)
    case 'analog'
        set(H.trigger_slope_popup, 'Enable', 'on');
        set(H.trigger_slope_popup, 'String', {'low_to_high', 'high_to_low'});
        set(H.trigger_level_text, 'String', 'Level[0-1]', 'Visible', 'on');
        set(H.analog_level_edit, 'Visible', 'on');
    case 'voice'
        set(H.trigger_slope_popup, 'Enable', 'off');
        set(H.trigger_level_text, 'String', 'Level[0-1]');
        set(H.optional_parm_push, 'Enable', 'on');
        set(H.advanced_parm_push, 'Enable', 'on');
    case 'emg'
        set(H.trigger_slope_popup, 'Enable', 'off');
        set(H.trigger_level_text, 'String', 'Level[0-1]');
        set(H.optional_parm_push, 'Enable', 'on');
        set(H.advanced_parm_push, 'Enable', 'on');
    case 'integer'
        set(H.trigger_slope_popup, 'Enable', 'on');
        set(H.trigger_slope_popup, 'String', {'const_start', 'const_end'});
        set(H.trigger_level_text, 'String', 'Bit pattern(H>L)', 'Visible', 'on');
        set(H.integer_level_edit, 'Visible', 'on');
        set(H.optional_parm_push, 'Enable', 'on');
    case 'bit'
        set(H.trigger_slope_popup, 'Enable', 'on');
        set(H.trigger_slope_popup, 'String', {'low_to_high', 'high_to_low'});
        set(H.trigger_level_text, 'String', 'Bit number', 'Visible', 'on');
        set(H.bit_level_edit, 'Visible', 'on');
        set(H.optional_parm_push, 'Enable', 'on');
    case 'multi channel pattern'
        set(H.trigger_slope_popup, 'Enable', 'on');
        set(H.trigger_slope_popup, 'String', {'const_start', 'const_end'});
        set(H.trigger_level_text, 'String', 'Channel pattern', 'Visible', 'on');
        set(H.flag_pattern_push, 'Visible', 'on');
end

Ntrigger = length(data.trigger_list);
trig_list_str = cell(0);
for k=1:Ntrigger
    % get brief explantion of trigger
    trig_list_str{k} = [sprintf('TRIGGER%d:', k), ...
                        vb_trigger_get_brief_str(data.trigger_list{k})];
end
set(H.trigger_list_listbox, 'String', trig_list_str);
if Ntrigger
    set(H.trigger_list_remove_push, 'Enable', 'on');
    set(H.trigger_list_view_push, 'Enable', 'on');
    set(H.trigger_edit_push,   'Enable', 'on');

else
    set(H.trigger_list_remove_push, 'Enable', 'off');
    set(H.trigger_list_view_push, 'Enable', 'off');
    set(H.trigger_edit_push,   'Enable', 'off');
end

% Trial extraction push button status
if isnumeric(pretrigger_ms) && ...
   pretrigger_ms > 0 && ...
   isnumeric(posttrigger_ms) && ...
   posttrigger_ms > 0 && ...
   Ntrigger > 0
   set(H.trigger_detect_push, 'Enable', 'on');
else
   set(H.trigger_detect_push, 'Enable', 'off');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Update Extracted trial list
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% TAGS
Ntags = length(data.label_list);
tag_name_list = cell(0);
if Ntags
    for k=1:Ntags
        tag_name_list{k} = vb_tag_get_tag_name(data.label_list{k});
    end
    set(H.tag_remove_push, 'Enable', 'on');
    set(H.add_to_output_list_button, 'Enable', 'on');
    set(H.channel_selection_push, 'Enable', 'on');
else
    set(H.tag_listbox, 'Value', 1);
    set(H.add_to_output_list_button, 'Enable', 'off');
    set(H.tag_remove_push, 'Enable', 'off');
    set(H.channel_selection_push, 'Enable', 'off');
end
set(H.tag_listbox, 'String', tag_name_list);

% Show trial according to selected tag
data = vb_trial_extractor_show_tag_trial(data);

% Selected labels
Nselected_label = size(get(H.tag_listbox, 'Value'), 2);
if isempty(get(H.tag_listbox, 'String'))
    Nselected_label = 0;
end
% Selected trials
Nselected_trials = size(get(H.trial_set_listbox, 'Value'), 2);
if isempty(get(H.trial_set_listbox, 'String'))
    Nselected_trials = 0;
end
% Trial add/edit/remove section state
set(H.trial_add_push, 'Enable', 'off');
set(H.trial_edit_push, 'Enable', 'off');
set(H.trial_remove_push, 'Enable', 'off');
if Nselected_label == 1
    set(H.trial_add_push, 'Enable', 'on');
end
if Nselected_label == 1 && Nselected_trials == 1
    set(H.trial_edit_push, 'Enable', 'on');
end
if Nselected_label == 1 && Nselected_trials >= 1
    set(H.trial_remove_push, 'Enable', 'on');
end
    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Update Output file list
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
output_file_list = cell(0);
Nfile = length(data.output_file);
for k=1:Nfile
    output_file_list{k} = data.output_file{k}.output_file;
end
set(H.output_listbox, 'String', output_file_list);
if Nfile
    set(H.output_settings_push, 'Enable', 'on');
    set(H.output_file_remove_push, 'Enable', 'on');
    set(H.output_file_push, 'Enable', 'on');
else
    set(H.output_settings_push, 'Enable', 'off');
    set(H.output_listbox, 'String', '');
    set(H.output_file_remove_push, 'Enable', 'off');
    set(H.output_file_push, 'Enable', 'off');
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive an application data.');
end
