function [data] = vb_trial_extractor_specify_display_channel(data)
% specify data channels displayed in trial viewer.
% [USAGE]
%    [data] = vb_trial_extractor_specify_display_channel(data)
% [IN]
%    data : vb_trial_extractor object
% [OUT]
%    data : vb_trial_extractor object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
[selected_ch_list, cancel] = ...
        vb_te_channel_selector_new(data.org_data_ch_list, ...
                                   data.view_data_ch_list);

if ~cancel
    data.view_data_ch_list = selected_ch_list;
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end
