function [data] = vb_trial_extractor_remove_output_file(data, idx)
% remove output file from output list.
% [USAGE]
%    [data] = vb_trial_extractor_remove_output_file(data, idx);
% [IN]
%    data : vb_trial_extractor object.
%      ix : selected listbox index [Nx1]
% [OUT]
%    data : vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('idx', 'var')
    error('idx is a required parameter.');
end
if size(idx, 2) ~= 1
    error('idx should be [Nx1] vector');
end

%
% --- Main Procedure
%
if length(data.output_file) >= size(idx, 1)
    data.output_file(idx) = []; % remove
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end
