function [data] = vb_trial_extractor_preview_trial(data, view_type)
% preview trial list
%
% [USAGE]
%    [data] = vb_trial_extractor_preview_trial(data, view_type);
% [IN]
%         data : vb_trial_extractor object
%    view_type : = 0 : data & trigger data & trial
%                = 1 : data & specific trigger channel & trial
% [OUT]
%    data : vb_trial_extractor object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('view_type', 'var')
    view_type = 0;
end

%
% --- Main Procedure
%

H = data.H;

if isempty(data.continuous_file), return; end
org_file = vb_continuous_file_get_filename(data.continuous_file);
if exist(org_file, 'file') ~= 2
    return;
end
trial_set = data.trial_list(data.showing_trial_ix);
trial_list_sec = vb_trial_extractor_convert_trial_into_sec(data, trial_set);

data_ch_list = data.view_data_ch_list;
ext_trig_ch_list = [];

% Trigger info
proc_parm_list = [];
selected_trig = [];
val = get(H.trigger_list_listbox, 'Value');
if ~isempty(val) && ~isempty(data.trigger_list)
    selected_trig = {data.trigger_list{val}};
end


for k=1:length(selected_trig)
    trig_parm = vb_trigger_get_parameter(selected_trig{k});
    trig_ch_list{k,1} = trig_parm.status_ch{1};
    % Digital trigger adjustment parameter
    if isfield(trig_parm, 'status_mask') && isfield(trig_parm, 'status_offset')
        proc_parm.type    = 'digital_data_adjustment';
        proc_parm.ch_name = trig_parm.status_ch{1};
        proc_parm.parm.bitmask = trig_parm.status_mask;
        proc_parm.parm.offset  = trig_parm.status_offset;
        proc_parm_list{length(proc_parm_list)+1} = proc_parm;
    end
end

if view_type == 0 % View extract result( trigger (+ data) (+trial) )
    % get channel list from Trigger list
    for k=1:size(data.trigger_list, 2)
        trig = vb_trigger_get_parameter(data.trigger_list{k});
        ext_trig_ch_list = [ext_trig_ch_list; trig.status_ch(:)];
    end
    if ~get(H.view_trial_with_data_check, 'Value')
        data_ch_list = [];
    end

elseif view_type == 1 % View extra channel(raw data)
    val = get(H.trigger_channel_listbox, 'Value');
    if ~isempty(val)
        list = get(H.trigger_channel_listbox, 'String');
        ext_trig_ch_list = list(val);
        trig_ch_list = [];
        proc_parm_list = [];
        trial_list_sec = [];
    end
    if ~get(H.view_trig_with_data_check, 'Value')
        data_ch_list = [];
    end
elseif view_type == 2 % View selected trigger
    val = get(H.trigger_list_listbox, 'Value');
    if ~isempty(val)
        for k=1:size(val,2)
            trig = vb_trigger_get_parameter(data.trigger_list{val(k)});
            ext_trig_ch_list = [ext_trig_ch_list; trig.status_ch(:)];
        end
        trial_list_sec = [];
        data_ch_list = [];
    end
end

% Launch viewer
[fig] = vb_timeseries_viewer_new(org_file, 30, data_ch_list, ...
                      trial_list_sec, unique(ext_trig_ch_list), proc_parm_list);

% Set title of figure
labels = cell(0);
if ~isempty(trial_list_sec)
    title = [];
    label_strs = get(H.tag_listbox, 'String');
    label_selected = get(H.tag_listbox, 'Value');
    Nselected = length(label_selected);
    
    for k=1:Nselected
        title = [title, label_strs{label_selected(k)} ','];
    end
    title(end) = '';
    set(fig, 'Name', ['Label : (' title ')']);
    
    if Nselected
        labels = label_strs(label_selected);
    end
end

% Save viewer info
if ~isfield(data, 'viewer')
    data.viewer = cell(0);
end

s = struct;
s.figure     = fig;
s.labels     = labels;
data.viewer{length(data.viewer)+1} = s;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end
