function vb_trial_extractor_batch_exec(trx_parm)
% extract trial and output MEG(EEG) mat file.
% [USAGE]
%    vb_trial_extractor_batch_exec(trx_parm);
% [IN]
%    trx_parm : Trial extraction parameter.
%
% =============================
%  * Continuous file section : Base continuous MEG/EEG file
%   trx_parm
%     .con_file   : <required> Continuous MEG/EEG MAT file <<string>>
%
% =============================
%  * Trial extraction section
%   trx_parm
%     .trigger_list{N} : <required> trigger settings <<cell>> {1xNtrigger}
%                                   see [Memo] in this help.
%       example:
%         trx_parm.trigger_list{1}     <<struct>>
%                 .status_ch = {'436'};
%                 .trig_type = 'analog';
%                 .status_level = 0.5;
%                 .slope     = 'low_to_high';
%         trx_parm.trigger_list{2}     <<struct>>
%                 .status_ch: {'437'};
%                 .trig_type: 'voice';
%                 .status_level: 0.0200;
%
%   trx_parm
%      .trial_setting : Trial settings <<struct>>
%         .pretrigger_ms  : <required> pretrigger length in miliseconds. 
%         .posttrigger_ms : <required> posttrigger length in miliseconds.
%         .minimum_distance_ms : <optional> minumum distance between 
%                                           trial onsets in miliseconds.
%        example:
%           trx_parm.trial_setting.pretrigger_ms = 500;
%           trx_parm.trial_setting.posttrigger_ms = 1000;
%           trx_parm.trial_setting.minimum_distance_ms = 1000;
%
%    ==>  Label named 'TRIGGERN' will be created by this operation
%
% =============================
%  * Trial Labeling section : <optional> Label to extracted trials.
%   trx_parm
%     .label_spec : label trials by file.       <<struct>>
%               .label_file : label file name <<string>>
%                             [label file format]
%                             label name is listed as below.
%                             each row coresponding to trials in base_label.
%                             (case-sensitive)
%                             =====
%                             LEFT
%                             RIGHT
%                             LOWER
%                             LEFT
%                             UPPER
%                             ...
%                             =====
%               .base_label : Specify label name which you want to label<<cell>> {1xN}
%                             example:
%                                .base_label = {'TRIGGER1', 'TRIGGER2'};
%                               if multiple labels are specified,
%                               it will be processed as below.
%                                 1.unite trials in labels.
%                                 2.sort trials by time in ascending order.
%                                 3.label trials by label_file.
%                                 4.new labels are created.
%    ==> As a result, new labels which are written in the label_file will be created.
%        (In this case, 'LEFT', 'RIGHT', 'UPPER', 'LOWER' labels will be created)
%   [For reference] extracted trial information.
%    trx_parm
%       .trial_list(n) : all extracted trial list. <<struct list>> [nx1]
%                        The order is not sorted. It just contains extracted trials.
%                .from    : The sample number of trial start point <<integer>> 
%                .to      : The sample number of trial end point   <<integer>>
%                .onset   : The sample number of trial onset point <<integer>>
%       .label_list{m}  : created label info
%            .name     : label name <<string>>.
%            .trial_ix : values are indicies of trx_parm.trial_list.  <<integer>> [mx1]
% =============================
% * Trial output section
%   trx_parm
%     .output_file{n}.label_name  : <required> output label name. <<string>>
%                    .output_file : <required> output filename(Evoked MEG/EEG-MAT) <<string>>
%                                              specify with extension(.meg.mat, .eeg.mat)
%            example:
%              trx_parm.output_file{1}.label_name  = 'TRIGGER1';
%              trx_parm.output_file{1}.output_file = 'TRIG1.meg.mat';
%
%     .output_sample_freq         : <optional> sampling frequency of output files.
%
% [OUT]
%    none
%
% [Memo]
%    Template parameter can be made easily by using vb_trial_extractor.
%     1.run vb_trial_extractor.
%     2.Input trigger setting.
%     3.Save parameter by "File->Save batch parameter(.trx.mat)".
%     4.load('saved.trx.mat', 'trx_parm'); % Modify parameter here if necessary.
%     5.run vb_trial_extractor_batch_exec(trx_parm);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('trx_parm', 'var')
    error('trx_parm is a required parameter.');
end

%err = inner_check_proc_spec(trx_parm);
%if err, error('Unknown field was detected.'); end

if isfield(trx_parm, 'output_file')
    output_file = trx_parm.output_file;
end
if isfield(trx_parm, 'con_file') && exist(trx_parm.con_file, 'file') == 2
    trx_parm.continuous_file = vb_continuous_file_new(trx_parm.con_file);
else
    error('Invalid trx_parm.con_file was specified..');
end

% set batch mode
trx_parm.batch_mode = true;

%
% --- Trial Extraction
%
trx_parm = vb_trial_extractor_extract_trial(trx_parm);

%
% --- Label Trial by file
%
if isfield(trx_parm, 'label_spec') && exist(trx_parm.label_spec.label_file, 'file') == 2
    trx_parm = vb_trial_extractor_tag_by_file(trx_parm, trx_parm.label_spec);
end

%
% --- Output Evoked MEG(EEG)-MAT
%

% output_file is initialized in vb_trial_extractor_extract_trial()
% so reset the field here.
trx_parm.output_file = output_file;

if exist('output_file', 'var') && ~isempty(output_file)
    trx_parm.output_file = output_file;
else
    warning('Cannot find output settings.');
    return;
end

% Output files
vb_trial_extractor_output_file(trx_parm);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% inner functions(Under construction)
%
function err = inner_check_proc_spec(trx_parm)
list = {'con_file', 'trigger_list', 'trial_setting', 'label_spec', 'output_file'};

% Check top level parameters
err = inner_check_fieldname(...
            'trx_parm', ...
            trx_parm, list);
if err, return; end

% Check second level parameters
if isfield(trx_parm, 'label_spec')
    list = {'label_file', 'base_label'};
    err = inner_check_fieldname(...
            'trx_parm.label_spec',...
            trx_parm.label_spec, list);
    if err, return; end
end
if isfield(trx_parm, 'trigger_list')
    list = {''};
end

if isfield(proc_spec, 'output_file')
    list = {'label_name', 'output_file'};
    for k=1:length(proc_spec.output_file)
        err = inner_check_fieldname(...
            ['proc_spec.outputfile{' num2str(k), '}'], ...
            proc_spec.output_file{k}, list);
        if err, return; end
    end
end

function err = inner_check_fieldname(struct_name, structure, list)

err = 0;
names = fieldnames(structure);
for k=1:length(names)
    hit = 0;
    for j=1:length(list)
        if strcmp(names{k}, list{j})
            hit = hit + 1;
        end
    end
    if hit == 0
        fprintf('Unknown field : %s\n', [struct_name '.' names{k}]);
        err = 1;
    end
end
