function data = vb_signal_processor_view_filter_response(data, parm)
% View filter response
% [USAGE]
%    data = vb_signal_processor_view_filter_response(data, parm);
% [IN]
%    data : Application data.
%    parm : filter parameter.
% [OUT]
%    data : Application data.
% See Also:
%    vb_plot_filter_response
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end

%
% --- Main Procedure
%
persistent freq_str;
if isempty(freq_str), freq_str = ''; end

ret = inputdlg('Enter the sampling frequency of the data[Hz]', 'View the selected filter response', 1, {freq_str}, 'on');
if ~isempty(ret)
    freq_str = ret{1};
    freq = str2double(freq_str);
else
   return;
end

d = vb_define_signal_processor;

online = 1;
ftype  = '';
Norder = 0;

switch(parm.type)
    case {d.TYPE_PROCESSING_HIGHPASS, d.TYPE_PROCESSING_LOWPASS}
        fcut   = parm.cutoff_freq;
        if parm.impulse_response == 2
            Norder = parm.order;
        end
        if parm.filtfilt
            online = 0;
        end
        if isequal(parm.type, d.TYPE_PROCESSING_HIGHPASS)
            ftype = 'high';
        else
            ftype = 'low';
        end
    case {d.TYPE_PROCESSING_BANDPASS, d.TYPE_PROCESSING_STOPBAND}
        fcut = [parm.cutoff_freq_low, parm.cutoff_freq_high];
        if parm.impulse_response == 2
            Norder = parm.order;
        end
        Norder = parm.order;
        if parm.filtfilt
            online = 0;
        end
        if isequal(parm.type, d.TYPE_PROCESSING_BANDPASS)
            ftype = 'band';
        else
            ftype = 'stop';
        end
    otherwise
        error('Unsupported filter was specified.');
end

figure;
vb_plot_filter_response(ftype, fcut, freq, Norder, [], [], online);
