function [data] = vb_signal_processor_set_file_type(data, file_type)
% Set file type for input file.
% [USAGE]
%    data = vb_signal_processor_set_file_type(data);
% [IN]
%    data : application data.
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
data.file_type = file_type;

d = vb_define_signal_processor;
%
% --- Processing list
%
strs = cell(0);
if strcmpi(file_type, 'MEG')
    data.process_template = d.process_template_MEG;
elseif strcmpi(file_type, 'EEG')
    data.process_template = d.process_template_EEG;
else
    error('Unknown file type was specified.');
end
for k=1:length(data.process_template)
    strs{k, 1} = vb_table_query_value(d.type_str_table, data.process_template{k});
end
set(data.H.process_type_listbox, 'String', strs, 'Value', 1);
data = vb_signal_processor_update_screen(data);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
