function data = vb_signal_processor_save_batch_script(data)
% save batch script as M-file.
% [USAGE]
%    data = vb_signal_processor_save_batch_script(data);
% [IN]
%    data : Application data.
% [OUT]
%    data : Application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
[d, flist] = vb_file_select({'.m'}, 'Save batch script file(.m)', true);
if ~isempty(d)
    save_file = fullfile(d, flist{1});
    if exist(save_file, 'file') == 2
        res = questdlg('Specified file already exists. overwrite?', ...
                       'Confirm', 'Yes', 'No', 'Yes');
        if strcmp(res, 'No'); return; end
    end
    fid = fopen(save_file, 'wt');
    if fid == -1
        errordlg('Cannot open save file.', 'Error');
        return;
    end
    proc_parm = struct;
    proc_parm.input_files  = data.input_files;
    proc_parm.output_files = data.output_files;
    proc_parm.process_list = data.process_list;
    parm_str = vb_struct2executable_str(proc_parm);
    fprintf(fid, 'function %s\n', strrep(flist{1}, '.m', ''));
    fprintf(fid, '%% Input/Ouput/Filter settings.\n');
    fprintf(fid, '%s\n', parm_str);
    fprintf(fid, '%% Apply signal processing to MEG/EEG-MAT file(s)\n');
    fprintf(fid, 'vb_signal_processor_batch_exec(proc_parm, 0)\n');
    fclose(fid);
    h = msgbox(sprintf('%s was created.', save_file), 'Notice');
    waitfor(h);
    edit(save_file);
end
