function data = vb_signal_processor_load_settings(data)
% Load batch file(.proc.mat)
% [USAGE]
%    data = vb_signal_processor_load_settings(data);
% [IN]
%    data : Application data.
% [OUT]
%    data : Application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
[d, flist] = vb_file_select({'.proc.mat'}, 'Load setting file(.proc.mat)');
if ~isempty(d)
    load_file = fullfile(d, flist{1});
    l = load(load_file);

    data.input_files  = l.proc_parm.input_files;
    data.output_files = l.proc_parm.output_files;
    data.process_list = l.proc_parm.process_list;
    
    output_dir_list = vb_signal_processor_get_output_dir_list(data);
    if length(output_dir_list) == 1
        set(data.H.output_dir_edit, 'String', output_dir_list{1});
    end
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
