function [dir_list] = vb_signal_processor_get_output_dir_list(data)
% get directory list from data.output_files
% [USAGE]
%    [dir_list] = vb_signal_processor_get_output_dir_list(data);
% [IN]
%    data : Application data.
% [OUT]
%    dir_list : output directory list.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
files  = data.output_files;
Nfiles = length(files);

dir_list = cell(0);
for k=1:Nfiles
    tmp = files{k};
    tmp = strrep(tmp, '.meg.mat', '');
    tmp = strrep(tmp, '.eeg.mat', '');
    [p] = vb_get_file_parts(tmp);

    dir_list{1, k} = p;
end
dir_list = unique(dir_list);
