function [data] = vb_signal_processor_create_output_filename(data)
% Set output directory.
% [USAGE]
%    data = vb_signal_processor_create_output_filename(data);
% [IN]
%    data : application data.
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

def = vb_define_extension;
switch(data.file_type)
    case 'MEG'
        extension = def.MEG2_EXTENSION;
    case 'EEG'
        extension = def.EEG_EXTENSION;
end

output_dir = get(H.output_dir_edit, 'String');
specific_output_place = false;
if ~isempty(output_dir)
    specific_output_place = true;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Create output file list from input files.
files     = data.input_files;
Nfiles    = length(files);
output_files = cell(0);

for k=1:Nfiles
    file = files{k};
    [d_, f_, e_] = vb_get_file_parts(strrep(file, extension, ''));
    if specific_output_place
        d_ = output_dir;
    end
    % create output filename(directory/filenamepostfix.(meg/eeg).mat)
    file_out = fullfile(d_, [f_, data.postfix, extension]);
    output_files{k} = file_out;
end
data.output_files = output_files;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive application data object.');
end
