function output_ix = vb_signal_processor_confirm_overwrite_files(data, mode)
% Show confirmation message(dialog or text) when 
% the candidate output files already exist.
% [USAGE]
%    data = vb_signal_processor_confirm_overwrite_files(data, mode);
% [IN]
%    data : application data.
%    mode : confirm overwrite
%         : = 0   : by text.    [default]
%         : = 1   : by dialog.
%         : = 2   : Yes to all.(with no check)
% [OUT]
%    output_ix : Index for data.output_files. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('mode', 'var')
    mode = 0; % text
end

%
% --- Main Procedure
%
output_ix = []; % 1:process, 0: don't process.

remove_pref;

if mode == 2
    output_ix = [1:1:length(data.output_files)]';
else
    Noutput_files = length(data.output_files);

    for k=1:Noutput_files
        file = data.output_files{k};
        if exist(file, 'file') == 2
% debug
%        if 1
            % file already exist.
            if mode == 1
                % confirm by dialog
                write = show_dialog(file);
            elseif mode == 0
                % confirm by text
                write = show_text(file);
            end
            if write
                output_ix = [output_ix; k];
            end
        else
            % file not exist. create file.
            output_ix = [output_ix; k];
        end
    end
end

remove_pref;

function remove_pref
if ispref('group', PREF_NAME)
    rmpref('group', PREF_NAME);
end

function write = show_text(file)
reply = '';
while(isempty(reply))
    if ispref('group', PREF_NAME)
        reply = 'yes';
    else
        reply = input([file ' already exist. overwrite? (Yes/No/All):'], 's');
    end
    switch(lower(reply))
        case {'yes', 'y'}
            write = 1;
        case {'no', 'n'}
            write = 0;
        case {'all', 'a'}
            write = 1;
            setpref('group', PREF_NAME, 1);
    end
end

function write = show_dialog(file)

% dialog
reply = uigetpref('group', ...
                PREF_NAME, ...
                'Confirmation', ...
                [file ' already exist. overwrite?'],...
                {'Yes', 'No'}, 'DefaultButton', 'No',...
                'CheckboxString', 'Apply to All');

% Judge
switch(lower(reply))
    case {'yes', 'y'}
        write = 1;
    case {'no', 'n'}
        write = 0;
    otherwise
        error('Unknown choice.');
end

function name = PREF_NAME
name = 'overwrite_megmat';

