function data = vb_signal_processor_change_process_order(data, direction)
% Change processing order of process list.
% [USAGE]
%    data = vb_signal_processor_change_process_order(data, direction);
% [IN]
%         data : Application data.
%    direction : current selected item will move to the speicifed direction.
%                = 'upper' : selected item will move to upper direction.
%                = 'lower' : selected item will move to lower direction.
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('direction', 'var')
    error('direction is a required parameter.');
end

%
% --- Main Procedure
%

current_pos = get(data.H.process_list_listbox, 'Value');
switch(lower(direction))
    case 'upper'
        new_pos = current_pos-1;
    case 'lower'
        new_pos = current_pos+1;
    otherwise
        error('Unknown direction was specified.');
end

if (new_pos <= 0) || new_pos > length(data.process_list)
    % do nothing
else
    current_item = data.process_list{current_pos};
    tmp = data.process_list{new_pos};
    data.process_list{new_pos} = current_item;
    data.process_list{current_pos} = tmp;
    set(data.H.process_list_listbox, 'Value', new_pos);
end

%
% --- After check
%
if nargout ~= 1
    error('Function caller should receive an updated application data');
end
