function pa_head_merge_parm(fig, merge_parm)
% merge head_parm which has head gui has and inputted head_parm fields.
% [USAGE]
%    pa_head_merge_parm(<fig> <,head_parm>);
% [IN]
%           fig : figure handle of head parameter gui.
%    merge_parm : To be merged head_parm.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var')|| isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end
if ~exist('merge_parm', 'var')
    error('merge_parm is a required parameter.');
end

%
% --- Main Procedure
%

% load data
data = guidata(fig);

parm_names = fieldnames(merge_parm);
for k=1:length(parm_names)
    data.head_parm.(parm_names{k}) = merge_parm.(parm_names{k});
end

% save data
guidata(fig, data);

