function [display_factor] = pa_head_load_display_factor(fig)
% create display_factor object to make 2D/3D view of Head file.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
% load data(@see pa_head_create)
data = guidata(fig);
H = data.H; % component handles

proj_root = get(H.prjroot_edit, 'String');
analyze_file = get(H.analyze_file_edit, 'String');
head_file    = get(H.head_file_edit, 'String');
%head_file_postfix = get(H.head_file_extension_text, 'String');
head_file    = fullfile(proj_root, head_file);

if exist(analyze_file, 'file') == 0
    errordlg('Analyze file should be inputted.');
    return;
end
if exist(head_file, 'file') == 0
    errordlg('Specified Head file does not exist.');
    return;
end

%
% --- Load head_file and create display_factor object
%

% Create head file manager
bm_obj = bm_manager_new;
[const] = define_bm_edit_app;
[bm_obj, result, bm_ix] = ...
        bm_manager_import_file(bm_obj, const.file_type.HEAD_FILE, ...
                               head_file, analyze_file);
if result == FAILURE
    errordlg('Failed to read head file.');
    return;
end
display_factor = bm_manager_get_display_factor(bm_obj, bm_ix);
