function pa_head_close(fig)
% This function close head GUI.
% [USAGE]
%    pa_head_close(<fig>);
% [IN]
%    fig : figure handle of head gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

%
% --- Main Procedure
%

% load data(@see pa_head_create)
data = guidata(fig);

% delete advanced parameter figure.
for k=1:length(data.adv_fig)
    if ishandle(data.adv_fig(k))
        delete(data.adv_fig(k));
    end
end

% delete main figure.
if ishandle(data.H.figure)
    delete(data.H.figure);
end
