function [parm_is_ok, msg] = pa_head_check_parm(fig, head_parm)
% This function check the parameter fields.
% When defectiveness is found, the reason will be shown.
%
% [USAGE]
%    [parm_is_ok, msg] = pa_head_check_parm(<fig>, <head_parm>);
% [IN]
%          fig : figure handle of gui.
%    head_parm : the parameter to be checked.
% [OUT]
%    parm_is_ok : check result  = true  : OK
%                               = false : NG
%           msg : error reason
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%                               
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end
if ~exist('head_parm', 'var'),
    error('head_parm is a required parameter.');
end

%
% --- Main Procedure
%
% load data(@see pa_brain_create)
data = guidata(fig);

H = data.H; % component handles

parm_is_ok = true;
msg = [];

try
% Nvertex
if ~isfield(head_parm, 'Nvertex') || ...
    head_parm.Nvertex < 0
    msg = 'The number of vertices is invalid.';
    error('go_to_catch_block');
end

% analyze_file
if ~isfield(head_parm, 'analyze_file') || ...
    exist(head_parm.analyze_file, 'file') == 0
    msg = 'Analyze file is needed.';
    error('go_to_catch_block');
end

% Nsurf
if ~isfield(head_parm, 'Nsurf') || ...
    head_parm.Nsurf < 0
    msg = 'The Model number is invalid.';
    error('go_to_catch_block');
end

% Voxel size
if ~isfield(head_parm, 'vstep') || ...
    head_parm.vstep < 0
    msg = 'Voxel size should be 1 or 2 mm';
    error('go_to_catch_block');
end

%
% --- CSF source
%
if get(H.csf_source_popup, 'Value') == 1
    % SPM segmentation file + Cortical model file [+ FreeSurfer file]

    % gray_file
    if ~isfield(head_parm, 'gray_file') || ...
        exist(head_parm.gray_file, 'file') == 0

        msg = 'SPM gray file is needed.';
        error('go_to_catch_block');
    end

    % brain_file
    proj_root = get(H.prjroot_edit, 'String');
    if ~isfield(head_parm, 'brain_file') || ...
        exist([proj_root, '/', head_parm.brain_file], 'file') == 0

        msg = 'Cortical model file is needed.';
        error('go_to_catch_block');
    end

elseif get(H.csf_source_popup, 'Value') == 2
    % Curry v4.5 surface file
    if ~isfield(head_parm, 'curry_file') || ...
        exist(head_parm.curry_file, 'file') == 0

        msg = 'Curry surface file is needed.';
        error('go_to_catch_block');
    end
else
    msg = 'internal error is occured.';
    error('go_to_catch_block');
end

%if head_parm.Nsurf > 1
    %
    % --- Skull source
    %
    if get(H.skull_source_popup, 'Value') == 1
        % use Scalp thickness
        if ~isfield(head_parm, 'Radius_scalp') || ...
           head_parm.Radius_scalp < 0
            msg = 'Scalp thickness is invalid.';
            error('go_to_catch_block');
        end
    elseif get(H.skull_source_popup, 'Value') == 2
        % FreeSurfer surface file(outer skull)
        if ~isfield(head_parm, 'fs_skull_file') || ...
           exist(head_parm.fs_skull_file, 'file') == 0

            msg = 'FreeSurfer surface file is needed.';
            error('go_to_catch_block');
        end
    else
        msg = 'internal error is occured.';
        error('go_to_catch_block');
    end

    %
    % --- Scalp source
    %
    if get(H.scalp_source_popup, 'Value') == 1
        % FreeSurfer surface file(outer skin)
        if ~isfield(head_parm, 'fs_scalp_file') || ...
           exist(head_parm.fs_scalp_file, 'file') == 0

            msg = 'FreeSurfer surface file(outer skin) is needed.';
            error('go_to_catch_block');
        end
    elseif get(H.scalp_source_popup, 'Value') == 2
        % Face file(made by positioning program)
        if ~isfield(head_parm, 'face_file') || ...
            exist(head_parm.face_file, 'file') == 0

            msg = 'Face surface file is needed.';
            error('go_to_catch_block');
        end
    end
%end

if ~isfield(head_parm, 'head_file') || ...
    isempty(head_parm.head_file);

    msg = 'Head file is needed.';
    error('go_to_catch_block');
end

catch
    parm_is_ok = false;
end

