function [fig] = pa_fmri_create(proj_root)
% create fMRI parameter gui.
% [USAGE]
%    fig = pa_fmri_create([proj_root]);
% [IN]
%    proj_root : project root directory
% [OUT]
%    fig : figure handle of fMRI parameter gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end

%
% --- Main Procedure
%
fig = openfig('pa_fmri.fig');

data = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.fmri_parm = vb_set_fmri_parm;
data.adv_fig = -1; % figure handle of fmri advanced parameter gui.

% save data to figure
guidata(fig, data);

set(data.H.prjroot_edit, 'String', proj_root);
pa_fmri_set_parm(fig, data.fmri_parm);
