function pa_brain_input_freesurfer_items(fig)
% Input freesurfer files just specifying directories.
% [IN]
%    fig : figure handle of GUI.
% [OUT]
%    none
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

data = guidata(fig);
H = data.H;

% previous choosen directory
persistent last_dir;
if isempty(last_dir), last_dir = pwd; end

% show directory dialog
d = dir_dialog(last_dir);
if isempty(d), return; end


try
    p = vb_freesurfer_get_files(struct, d);
catch
    [msg, msg_f] = vb_get_error_msg(lasterror);
    errordlg(msg_f, 'error');
    return;
end

% update previous choosen directory
last_dir = d;

% 'FS_LEFT_BRAIN'
set(H.freesurfer_left_edit, 'String', p.FS_left_file);

% 'FS_RIGHT_BRAIN'
set(H.freesurfer_right_edit, 'String', p.FS_right_file);

% 'FS_LEFT_INFLATE_BRAIN'
set(H.freesurfer_left_inflate_edit, 'String', p.FS_left_infl_file);

% 'FS_RIGHT_INFLATE_BRAIN'
set(H.freesurfer_right_inflate_edit, 'String', p.FS_right_infl_file);

% 'FS_LEFT_CURVATURE'
set(H.freesurfer_left_curv_edit, 'String', p.FS_left_curv_file);

% 'FS_RIGHT_CURVATURE'
set(H.freesurfer_right_curv_edit, 'String', p.FS_right_curv_file);

% 'FS_LEFT_CORTEX_LABEL'
set(H.freesurfer_left_label_edit, 'String', p.FS_left_label_file);

% 'FS_RIGHT_CORTEX_LABEL'
set(H.freesurfer_right_label_edit, 'String', p.FS_right_label_file);

% 'FS_LEFT_SPHERE_FILE'
set(H.freesurfer_left_sphere_edit, 'String', p.FS_left_sphere_file);

% 'FS_RIGHT_SPHERE_FILE'
set(H.freesurfer_right_sphere_edit, 'String', p.FS_right_sphere_file);
