function current_gui_advanced_callback(fig, hObj)
% current advanced parameter gui callback function.
% [USAGE]
%    current_gui_advanced_callback(fig, hObj);
% [IN]
%     fig : current_gui_advanced parameter figure handle
%    hObj : component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var'), error('fig is a required parameter.'); end
if ~exist('hObj', 'var'), error('hObj is a required parameter.'); end

%
% --- Main Procedure
%

data = guidata(fig);
H = data.H;

switch(hObj)
    case {H.overlapped_radiobutton, H.concatenate_radiobutton}
        radiobutton_group = [H.overlapped_radiobutton, ...
                             H.concatenate_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case H.cancel_push
        current_gui_advanced_delete(fig);
    case H.ok_push
        current_parm = current_gui_advanced_get_parm_gui(fig);
        current_gui(data.parent, 'merge_parm', current_parm);
        current_gui_advanced_delete(fig);
end
