function [obj] = brain_file_maker_view2d(obj, brain_file, analyze_info)
% launch vb_mri_point_select to check cortex form.
% [USAGE]
%    [obj] = brain_file_maker_view2d(<obj>, <brain_file>, <analyze_file>);
% [IN]
%             obj : brain_file_maker object
%      brain_file : brain_file(.brain.mat)   (fullpath)
%    analyze_info : analyze_info object
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_file', 'var')
    error('brain_file is a required parameter.');
end
if ~exist('analyze_info', 'var')
    error('analyze_info is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;

Vdim  = vb_analyze_info_get_voxdim(analyze_info);
Vsize = vb_analyze_info_get_voxsize(analyze_info);
analyze_file = vb_analyze_info_get_file_prefix(analyze_info);
% load brain data
load(brain_file, 'V', 'F', 'xx');

% convert coordinate to plot
V = vb_spm_right_to_analyze_right_mm(V, Vdim, Vsize);
coord_type = vbmeg_inst.const.COORDINATE_ANALYZE_RIGHT_MM;

% make display data
element = vb_surf_element_new('brain mat loaded data', coord_type, V, F.F3, xx);
clear V F xx;
display_factor = vb_display_factor_new;
display_factor = vb_display_factor_add_element(display_factor, element);
clear element;

% display by vb_mri_point_select
evalin('base', 'clear avw');
if ~ishandle(obj.view2d)
    % Run vb_mri_point_select
    avw = avw_read_ras(analyze_file);
    avw.display_factor = display_factor;
    vb_mri_point_select(avw, '', 'init');
    obj.view2d = gcf;
    set(obj.view2d, 'Unit', 'normalized');
    set(obj.view2d, 'Position', [0.35, 0.2, 0.6, 0.6]);
else
    % Update mri_point select screen
    figure(obj.view2d);
    set(0, 'CurrentFigure', obj.view2d);
    AVWVIEW = get(obj.view2d, 'Userdata');
    % replace display data
    AVWVIEW.display_factor = display_factor;
    set(obj.view2d, 'Userdata', AVWVIEW);
    % display update
    vb_mri_point_select([], [], 'update');
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
