function [obj] = brain_file_maker_update_display(obj)
% display update of brain_file_maker gui
% [USAGE]
%    [obj] = brain_file_maker_update_display(<obj>);
% [IN]
%    obj : brain_file_maker object
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
global vbmeg_inst;
const = vbmeg_inst.const;
H = obj.H;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Project root directory
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(H.proj_root_edit, 'String', obj.proj_root);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Viewer and Smoother section
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Input directory
brain_dir = [obj.proj_root, filesep, obj.brain_dir];

if ~isempty(brain_dir)
    brain_file = dir([brain_dir, '/*', const.BRAIN_EXTENSION]);
    area_file  = dir([brain_dir, '/*', const.AREA_EXTENSION]);
    act_file   = dir([brain_dir, '/*', const.FMRI_EXTENSION]);

    % file list
    brain_file = {brain_file.name};
    area_file  = {area_file.name};
    act_file   = {act_file.name};

    % filter filename by strmatch
    filter_str = get(H.filter_edit, 'String');
    if length(filter_str) ~= 0
        ix = strmatch(filter_str, brain_file);
        brain_file = brain_file(ix);
        ix = strmatch(filter_str, area_file);
        area_file  = area_file(ix);
        ix = strmatch(filter_str, act_file);
        act_file   = act_file(ix);
    end
else
    brain_file = '';
    area_file  = '';
    act_file   = '';
end

% set filename to each listbox
set(H.brain_file_listbox, 'String', brain_file);
set(H.area_file_listbox,  'String', area_file);
set(H.act_file_listbox,   'String', act_file);
set(H.brain_file_listbox, 'Value', 1);
set(H.area_file_listbox,  'Value', 1);
set(H.act_file_listbox,   'Value', 1);

obj = brain_file_maker_set_selected_filename(obj);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Making Cortical files section
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Analyze file
set(H.analyze_file_edit, 'String', obj.analyze_file);

% Product type
set(H.product_type_popup, 'Value', obj.product_type);

% change object inner filename information
obj = brain_file_maker_set_output_filename(obj);

% SPM normalization file
set(H.spm_norm_file_edit, 'String', obj.spm_norm_file);

% Comment
set(H.output_brain_file_comment, 'String', obj.comment);

% set output filename to text
set(H.brain_file_output_filename_edit, 'String', obj.brain_file_output_filename);
set(H.brain_file_output_dir_edit, 'String', obj.brain_file_output_dir);
set(H.output_mask_file_text, 'String', obj.output_mask_file);
set(H.output_brain_file_text, 'String', obj.output_brain_file);
set(H.output_area_file_text,  'String', obj.output_area_file);
set(H.output_act_file_text,   'String', obj.output_act_file);


% update ui status
obj = brain_file_maker_update_ui_state(obj);

%
% --- After check
%
if nargout ~= 1
    error('function caller should received obj.');
end
