function [obj] = brain_file_maker_set_parm(obj, parm)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end

%
% --- Main procedure
%
if isfield(parm, 'analyze_file')
    obj.analyze_file = parm.analyze_file;
    obj.analyze_info = vb_analyze_info_new(parm.analyze_file);
end

% Product type
if isfield(parm, 'std_brain')
    obj.product_type = 1;
elseif isfield(parm, 'subj_mask')
    obj.product_type = 2;
else
    error('invalid parameter was specified.');
end

% Comment
if isfield(parm, 'comment')
    obj.comment = parm.comment;
end

% SPM normalization file
if isfield(parm, 'spm_normalization_file')
    obj.spm_norm_file = parm.spm_normalization_file;
end

% Cortical files
if isfield(parm, 'brain_file')
    obj.output_brain_file = parm.brain_file;

    % make output setting from parameter
    global vbmeg_inst;
    [p_, f_, e_] = vb_get_file_parts(obj.output_brain_file);
    obj.brain_file_output_dir = p_;
    obj.brain_file_output_filename = ...
        strrep([f_, e_], vbmeg_inst.const.BRAIN_EXTENSION, '');
end
if isfield(parm, 'area_file')
    obj.output_area_file = parm.area_file;
end
if isfield(parm, 'act_file')
    obj.output_act_file = parm.act_file;
end

% Mask file
if isfield(parm, 'subj_mask')
    obj.output_mask_file = parm.subj_mask;
end


% save application instance to figure
guidata(obj.H.figure, obj);

[obj] = brain_file_maker_update_display(obj);

%
% --- After check
%
if nargout ~= 1
    error('function caller should received obj.');
end
