function [figure_h] = brain_file_maker_get_figure_handle(obj)
% get figure handle from brain_file_maker object
% [USAGE]
%    figure_h = brain_file_maker_get_figure_handle(obj);
% [IN]
%    obj : brain_file_maker object
% [OUT]
%    figure_h : figure handle of brain_file_maker gui
% Author: rhayashi
% Created: 2010-02-08
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~strcmp(obj.class_name, 'brain_file_maker')
    error('obj is not brain_file_maker''s object');
end


%
% --- Main Procedure
%
figure_h = obj.H.figure;
