function [obj, cancelled] = brain_file_maker_edit_parm(obj, parm_type)
% edit parameter by gui
% [USAGE]
%    [obj] = brain_file_maker_edit_job_smooth_cortex_parm(<obj>);
% [IN]
%          obj : brain_file_maker object
%    parm_type : edit parameter type
% [OUT]
%          obj : brain_file_maker object
%    cancelled : true or false(true means cancelled).
%
% Author: rhayashi
% Created: 2007-07-25
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
const = define_brain_file_maker;
switch(parm_type)
    case const.JOB_SMOOTH_CORTEX_PARM
        parm = job_smooth_cortex_parm_get_parm(obj.job_smooth_cortex_parm);
        caption = 'smoothing parameter';
    case  const.JOB_BRAIN_STD2SBJ_PARM
        parm = job_brain_std2sbj_parm_get_parm(obj.job_brain_std2sbj_parm);
        caption = 'make brain file parameter';
end

[parm, cancelled] = vb_edit_struct(parm, caption);

if cancelled == false
    switch(parm_type)
        case  const.JOB_SMOOTH_CORTEX_PARM
            [obj.job_smooth_cortex_parm, result] = ...
                job_smooth_cortex_parm_set_parm(obj.job_smooth_cortex_parm, parm);
        case  const.JOB_BRAIN_STD2SBJ_PARM
            [obj.job_brain_std2sbj_parm, result] = ...
                job_brain_std2sbj_parm_set_parm(obj.job_brain_std2sbj_parm, parm);
    end
    if result == FAILURE
        errordlg('Parameter is invalid.');
        cancelled = true;
    end
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
